/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

public final class PGPSignatureUtils {
    private PGPSignatureUtils() {
    }

    public static PGPSignature loadSignature(InputStream input) throws IOException {
        InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)input);
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(sigInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Object object = pgpObjectFactory.nextObject();
        if (!(object instanceof PGPSignatureList)) {
            throw new ProtocolException("File content is not a PGP signature.");
        }
        PGPSignatureList siglist = (PGPSignatureList)object;
        if (siglist.isEmpty()) {
            throw new ProtocolException("PGP signature list is empty.");
        }
        return siglist.get(0);
    }

    public static void readFileContentInto(PGPSignature signature, File file) throws IOException {
        try (BufferedInputStream inArtifact = new BufferedInputStream(new FileInputStream(file));){
            int t;
            while ((t = ((InputStream)inArtifact).read()) >= 0) {
                signature.update((byte)t);
            }
        }
    }
}

