/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.transform.FileTransformer;
import org.simplify4u.plugins.sign.ArtifactSigner;
import org.simplify4u.plugins.sign.SignMojoException;
import org.simplify4u.plugins.sign.SignResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ArtifactSigner40
extends ArtifactSigner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactSigner40.class);
    @Inject
    private MavenSession session;

    @Override
    public List<SignResult> signArtifact(org.apache.maven.artifact.Artifact artifact) {
        ArrayList<SignResult> result;
        block16: {
            LOGGER.info("Signing artifact: {}", (Object)artifact);
            Artifact srcArtifact = this.mArtifactToAether(artifact);
            Collection transformersForArtifact = this.session.getRepositorySession().getFileTransformerManager().getTransformersForArtifact(srcArtifact);
            result = new ArrayList<SignResult>();
            try {
                if (transformersForArtifact.isEmpty()) {
                    try (BufferedInputStream artifactInputStream = new BufferedInputStream(Files.newInputStream(srcArtifact.getFile().toPath(), new OpenOption[0]));){
                        result.add(this.makeSignature(srcArtifact, artifactInputStream));
                        break block16;
                    }
                }
                for (FileTransformer fileTransformer : transformersForArtifact) {
                    Artifact dstArtifact = fileTransformer.transformArtifact(srcArtifact);
                    result.add(this.makeSignature(dstArtifact, fileTransformer.transformData(srcArtifact.getFile())));
                }
            }
            catch (IOException e) {
                throw new SignMojoException(e);
            }
        }
        return result;
    }
}

