/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.codehaus.plexus.util.SelectorUtils;
import org.simplify4u.plugins.sign.ArtifactSigner;
import org.simplify4u.plugins.sign.ArtifactSignerFactory;
import org.simplify4u.plugins.sign.KeyInfoFactory;
import org.simplify4u.plugins.sign.SignMojoException;
import org.simplify4u.plugins.sign.SignResult;
import org.simplify4u.plugins.sign.openpgp.PGPKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="sign", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SignMojo
extends AbstractMojo {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SignMojo.class);
    @Inject
    private MavenProject project;
    @Inject
    private MavenProjectHelper projectHelper;
    @Inject
    private KeyInfoFactory keyInfoFactory;
    @Inject
    private ArtifactSignerFactory artifactSignerFactory;
    @Parameter(property="sign.serverId")
    private String serverId;
    @Parameter(property="sign.keyId")
    private String keyId;
    @Parameter(property="sign.keyPass")
    private String keyPass;
    @Parameter(property="sign.keyFile", defaultValue="${user.home}/.m2/sign-key.asc")
    private File keyFile;
    @Parameter(property="sign.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="sign.skipNoKey", defaultValue="true")
    private boolean skipNoKey;
    @Parameter(defaultValue="**/*.md5,**/*.sha1,**/*.sha256,**/*.sha512,**/*.asc")
    private List<String> excludes = Collections.emptyList();

    public void setExcludes(List<String> excludes) {
        String from = File.separatorChar == '/' ? "\\\\" : "/";
        this.excludes = excludes.stream().map(s -> s.replace(from, File.separator)).collect(Collectors.toList());
    }

    public void execute() {
        if (this.skip) {
            LOGGER.info("Sign - skip execution");
            return;
        }
        PGPKeyInfo keyInfo = this.keyInfoFactory.buildKeyInfo(KeyInfoFactory.KeyInfoRequest.builder().serverId(this.serverId).id(this.keyId).pass(this.keyPass).file(this.keyFile).build());
        if (!keyInfo.isKeyAvailable()) {
            if (this.skipNoKey) {
                LOGGER.info("Sign - key not found - skip execution");
                return;
            }
            throw new SignMojoException("Required key for signing not found");
        }
        ArtifactSigner artifactSigner = this.artifactSignerFactory.getSigner(keyInfo);
        HashSet<Object> artifactsToSign = new HashSet<Object>();
        ProjectArtifact projectArtifact = new ProjectArtifact(this.project);
        artifactsToSign.add(projectArtifact);
        Artifact artifact = this.project.getArtifact();
        if (artifact.getFile() != null) {
            artifactsToSign.add(artifact);
        } else if (!artifact.equals(projectArtifact)) {
            LOGGER.info("Primary artifact doesn't have the file to sign, continue with attached artifacts.");
        }
        artifactsToSign.addAll(this.project.getAttachedArtifacts());
        artifactsToSign.stream().map(SignMojo::verifyArtifact).filter(this::shouldBeSigned).map(artifactSigner::signArtifact).flatMap(Collection::stream).forEach(this::attachSignResult);
    }

    private static Artifact verifyArtifact(Artifact artifact) {
        if (artifact == null) {
            throw new SignMojoException("null artifacts ...");
        }
        if (artifact.getFile() == null) {
            throw new SignMojoException("Artifact: " + artifact + " has no file");
        }
        return artifact;
    }

    private boolean shouldBeSigned(Artifact artifact) {
        Path projectBasePath = this.project.getBasedir().toPath();
        Path artifactPath = artifact.getFile().toPath();
        String relativeArtifactPath = projectBasePath.relativize(artifactPath).toString();
        boolean shouldSign = this.excludes.stream().noneMatch(exclude -> SelectorUtils.matchPath((String)exclude, (String)relativeArtifactPath));
        LOGGER.debug("Artifact: {} with relativeArtifactPath: {} shouldSign: {} due to excludes: {}", new Object[]{artifact, relativeArtifactPath, shouldSign, this.excludes});
        return shouldSign;
    }

    private void attachSignResult(SignResult signResult) {
        LOGGER.info("Attach signature: {}", (Object)signResult);
        this.projectHelper.attachArtifact(this.project, signResult.getExtension(), signResult.getClassifier(), signResult.getFile());
    }

    @Generated
    void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    @Generated
    void setKeyFile(File keyFile) {
        this.keyFile = keyFile;
    }

    @Generated
    void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Generated
    void setSkipNoKey(boolean skipNoKey) {
        this.skipNoKey = skipNoKey;
    }
}

