/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign.openpgp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public final class PGPKeyInfo {
    private final Long id;
    private final String pass;
    private final byte[] key;

    public boolean isKeyAvailable() {
        return this.key != null && this.key.length > 0;
    }

    public InputStream getKeyStream() {
        return new ByteArrayInputStream(this.key);
    }

    public char[] getPass() {
        return Optional.ofNullable(this.pass).map(String::toCharArray).orElse(null);
    }

    @Generated
    PGPKeyInfo(Long id, String pass, byte[] key) {
        this.id = id;
        this.pass = pass;
        this.key = key;
    }

    @Generated
    public static PGPKeyInfoBuilder builder() {
        return new PGPKeyInfoBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public byte[] getKey() {
        return this.key;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PGPKeyInfo)) {
            return false;
        }
        PGPKeyInfo other = (PGPKeyInfo)o;
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        if (!Arrays.equals(this.getPass(), other.getPass())) {
            return false;
        }
        return Arrays.equals(this.getKey(), other.getKey());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPass());
        result = result * 59 + Arrays.hashCode(this.getKey());
        return result;
    }

    @Generated
    public String toString() {
        return "PGPKeyInfo(id=" + this.getId() + ", pass=" + Arrays.toString(this.getPass()) + ", key=" + Arrays.toString(this.getKey()) + ")";
    }

    @Generated
    public static class PGPKeyInfoBuilder {
        @Generated
        private Long id;
        @Generated
        private String pass;
        @Generated
        private byte[] key;

        @Generated
        PGPKeyInfoBuilder() {
        }

        @Generated
        public PGPKeyInfoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        @Generated
        public PGPKeyInfoBuilder pass(String pass) {
            this.pass = pass;
            return this;
        }

        @Generated
        public PGPKeyInfoBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        @Generated
        public PGPKeyInfo build() {
            return new PGPKeyInfo(this.id, this.pass, this.key);
        }

        @Generated
        public String toString() {
            return "PGPKeyInfo.PGPKeyInfoBuilder(id=" + this.id + ", pass=" + this.pass + ", key=" + Arrays.toString(this.key) + ")";
        }
    }
}

