/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign.utils;

import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class Environment {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Environment.class);
    private final UnaryOperator<String> environmentGetter;

    public Environment() {
        this(System::getenv);
    }

    Environment(UnaryOperator<String> environmentGetter) {
        this.environmentGetter = environmentGetter;
    }

    public Optional<String> getEnv(String environmentName) {
        Optional<String> returnValue = Optional.ofNullable(this.environmentGetter.apply(environmentName)).map(String::trim).filter(s -> !"null".equals(s)).filter(s -> !s.isEmpty());
        if (returnValue.isPresent()) {
            LOGGER.debug("Retrieved {} configuration from environment variable", (Object)environmentName);
        } else {
            LOGGER.debug("No {} set as environment variable", (Object)environmentName);
        }
        return returnValue;
    }
}

