/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sitemapxml;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Mojo(name="gen", defaultPhase=LifecyclePhase.SITE, threadSafe=true)
public class SiteMapXmlMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteMapXmlMojo.class);
    private static final Pattern PATTERN_END_SLASH = Pattern.compile("/+$");
    private String siteUrl;
    private List<Pattern> patternIncludes;
    @Parameter(property="siteOutputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true)
    private File siteOutputDirectory;
    @Parameter(property="maven.site.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="sitemapxml.maxdept", defaultValue="1")
    private int maxDepth;
    @Parameter(defaultValue="index.html", required=true)
    private List<String> indexPages;

    @Parameter(property="sitemapxml.siteurl", defaultValue="${project.url}", required=true)
    public void setSiteUrl(String siteUrl) {
        if (siteUrl.endsWith("/")) {
            siteUrl = PATTERN_END_SLASH.matcher(siteUrl).replaceFirst("");
        }
        this.siteUrl = siteUrl;
    }

    @Parameter(defaultValue="*.html", required=true)
    public void setIncludes(List<String> includes) {
        this.patternIncludes = includes.stream().map(s -> s.replace(".", "\\.")).map(s -> s.replace("*", ".*")).map(Pattern::compile).collect(Collectors.toList());
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setIndexPages(List<String> indexPages) {
        this.indexPages = indexPages;
    }

    public void execute() throws MojoFailureException {
        if (this.skip) {
            LOGGER.info("Skipping sitemap.xml generation");
            return;
        }
        LOGGER.info("Generate sitemap.xml - Start");
        LOGGER.debug("Site local directory: {}", (Object)this.siteOutputDirectory);
        LOGGER.debug("Site url: {}", (Object)this.siteUrl);
        LOGGER.debug("Includes: {}", this.patternIncludes);
        if (!this.siteOutputDirectory.exists()) {
            throw new MojoFailureException(String.format("site directory %s not exist - please run with site phase", this.siteOutputDirectory));
        }
        try {
            ArrayList<String> urls = new ArrayList<String>();
            this.listDirectory(1, this.siteOutputDirectory, urls);
            this.generateXML(urls);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MojoFailureException("Generate sitemap.xml error: " + e.getMessage(), (Throwable)e);
        }
        LOGGER.info("Generate sitemap.xml - OK");
    }

    private void generateXML(List<String> urls) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element urlset = document.createElement("urlset");
        urlset.setAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
        document.appendChild(urlset);
        for (String file : urls) {
            Element url = document.createElement("url");
            Element loc = document.createElement("loc");
            loc.appendChild(document.createTextNode(file));
            url.appendChild(loc);
            urlset.appendChild(url);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(this.siteOutputDirectory, "sitemap.xml"));
        transformer.transform(source, streamResult);
    }

    private void listDirectory(int depth, File siteOutputDirectory, List<String> urls) {
        ArrayList<Object> nextDirs = new ArrayList<Object>();
        Object[] listFiles = Optional.ofNullable(siteOutputDirectory).map(dir -> dir.listFiles(new OurFilenameFilter())).orElseGet(() -> new File[0]);
        Arrays.sort(listFiles);
        for (Object file : listFiles) {
            if (((File)file).isDirectory()) {
                nextDirs.add(file);
                continue;
            }
            LOGGER.debug("add file to list: {}", file);
            this.appendFile(urls, (File)file);
        }
        if (depth < this.maxDepth) {
            for (File file : nextDirs) {
                this.listDirectory(depth + 1, file, urls);
            }
        }
    }

    private void appendFile(List<String> urls, File file) {
        File absoluteFile = file.getAbsoluteFile();
        String absolutePath = this.indexPages.contains(absoluteFile.getName()) ? absoluteFile.getParent() + "/" : absoluteFile.getPath();
        String fileToAdd = absolutePath.replace(this.siteOutputDirectory.getAbsolutePath(), "");
        fileToAdd = fileToAdd.replace("\\", "/");
        urls.add(this.siteUrl + fileToAdd);
    }

    class OurFilenameFilter
    implements FilenameFilter {
        OurFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            if (f.isDirectory()) {
                return true;
            }
            return SiteMapXmlMojo.this.patternIncludes.stream().anyMatch(p -> p.matcher(name).find());
        }
    }
}

