/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.slf4jmock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.simplify4u.slf4jmock.internal.ProxyMock;

class MockInvocationHandler
implements InvocationHandler,
ProxyMock {
    private final String name;
    private final ThreadLocal<Object> mockThreadLocal;

    public MockInvocationHandler(String name, Supplier<?> defaultMock) {
        this.name = name;
        this.mockThreadLocal = ThreadLocal.withInitial(defaultMock);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == ProxyMock.class) {
            return method.invoke((Object)this, args);
        }
        return method.invoke(this.mockThreadLocal.get(), args);
    }

    @Override
    public void setMock(Object mock) {
        this.mockThreadLocal.set(mock);
    }

    @Override
    public Object getMock() {
        return this.mockThreadLocal.get();
    }

    @Override
    public void clearMock() {
        this.mockThreadLocal.remove();
    }

    @Override
    public String getMockName() {
        return this.name;
    }
}

