/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.slf4jmock.mockito;

import java.lang.reflect.Method;
import org.mockito.exceptions.stacktrace.StackTraceCleaner;
import org.mockito.plugins.StackTraceCleanerProvider;

public class LoggerStackTraceCleanerProvider
implements StackTraceCleanerProvider {
    public StackTraceCleaner getStackTraceCleaner(StackTraceCleaner defaultCleaner) {
        return candidate -> defaultCleaner.isIn(candidate) && !LoggerStackTraceCleanerProvider.isJdkInternal(candidate) && !LoggerStackTraceCleanerProvider.isSlf4jMock(candidate);
    }

    private static boolean isJdkInternal(StackTraceElement candidate) {
        return candidate.isNativeMethod() || candidate.getLineNumber() < 0 || candidate.getClassName().startsWith("sun.") || candidate.getClassName().startsWith("jdk.internal.reflect") || candidate.getClassName().equals(Method.class.getName());
    }

    private static boolean isSlf4jMock(StackTraceElement candidate) {
        return "org.simplify4u.slf4jmock.MockInvocationHandler".equals(candidate.getClassName()) || "org.slf4j.MDC".equals(candidate.getClassName());
    }
}

