/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.sjf4jmock;

import java.util.HashMap;
import java.util.Map;
import org.mockito.Mockito;
import org.simplify4u.sjf4jmock.DelegateMockToSimpleLogger;
import org.simplify4u.sjf4jmock.SimpleLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LoggerFactory
implements ILoggerFactory {
    private static final Logger LOGGER = new SimpleLogger(LoggerFactory.class.getName());
    private Map<String, Logger> loggers = new HashMap<String, Logger>();

    LoggerFactory() {
    }

    public Logger getLogger(String name) {
        return this.loggers.computeIfAbsent(name, this::createNewLoggerMock);
    }

    private Logger createNewLoggerMock(String name) {
        LOGGER.info("Create mock for logger: {}", (Object)name);
        Logger mock = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        new DelegateMockToSimpleLogger(name).delegate(mock);
        return mock;
    }

    void clearInvocations() {
        this.loggers.forEach((name, logger) -> Mockito.clearInvocations((Object[])new Logger[]{logger}));
    }
}

