/*
 * Decompiled with CFR 0.152.
 */
package org.sinnlabs.zk.ui;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Textbox;

public class CodeMirror
extends Textbox {
    private static final long serialVersionUID = -6278831344472300331L;
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";
    public static final String JAVA = "text/x-java";
    public static final String JAVASCRIPT = "text/javascript";
    public static final String C = "text/x-csrc";
    public static final String CPP = "text/x-c++src";
    public static final String OBJECTIVE_C = "text/x-objectivec";
    public static final String SCALA = "text/x-scala";
    public static final String KOTLIN = "text/x-kotlin";
    public static final String CEYLON = "text/x-ceylon";
    public static final String CSHARP = "text/x-csharp";
    public static final String JSON = "application/json";
    public static final String LD_JSON = "application/ld+json";
    public static final String TYPESCRIPT = "text/typescript";
    public static final String CSS = "text/css";
    public static final String SCSS = "text/x-scss";
    public static final String LESS = "text/x-less";
    public static final String XML = "application/xml";
    public static final String TIDDLY_WIKI = "text/x-tiddlywiki";
    public static final String TIKI_WIKI = "text/tiki";
    public static final String ASCIIDOC = "text/asciidoc";
    public static final String SQL = "text/x-sql";
    public static final String MYSQL = "text/x-mysql";
    public static final String MARIADB = "text/x-mariadb";
    public static final String CASANDRA = "text/x-cassandra";
    public static final String PLSQL = "text/x-plsql";
    public static final String MSSQL = "text/x-mssql";
    public static final String HIVE = "text/x-hive";
    public static final String PGSL = "text/x-pgsql";
    public static final String GQL = "text/x-gql";
    public static final String GQSQL = "text/x-gpsql";
    public static final String ESPER = "text/x-esper";
    public static final String GROOVY = "text/x-groovy";
    private static final Map<String, Set<String>> modeExtensions = new HashMap<String, Set<String>>();
    private String _mode = "text/html";
    private boolean _lineNumbers = false;

    public CodeMirror() {
        this.setZclass("z-div");
    }

    public CodeMirror(String value) {
        super(value);
        this.setZclass("z-div");
    }

    public String getMode() {
        return this._mode;
    }

    public void setMode(String name) {
        this._mode = name;
        this.smartUpdate("mode", this._mode);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "mode", this._mode);
        this.render(renderer, "lineNumbers", this._lineNumbers);
    }

    private static String findModeByExtension(String extension) {
        if (extension != null && !extension.isEmpty()) {
            for (Map.Entry<String, Set<String>> i : modeExtensions.entrySet()) {
                Set<String> exts = i.getValue();
                if (!exts.contains(extension)) continue;
                return i.getKey();
            }
        }
        return TEXT_HTML;
    }

    public void setSyntax(String extension) {
        this.setMode(CodeMirror.findModeByExtension(extension));
    }

    public boolean getLineNumbers() {
        return this._lineNumbers;
    }

    public void setLineNumbers(boolean value) {
        this._lineNumbers = value;
        this.smartUpdate("lineNumbers", this._lineNumbers);
    }

    static {
        HashSet<String> clikeExts = new HashSet<String>();
        clikeExts.addAll(Arrays.asList("c", "h", "cpp", "c++", "cc", "cxx", "hpp", "h++", "hh", "hxx", "cs", "java", "kt", "m", "mm", "scala", "nut"));
        modeExtensions.put("clike", clikeExts);
        HashSet<String> cssExts = new HashSet<String>();
        cssExts.addAll(Arrays.asList("gss", "css", "less", "scss"));
        modeExtensions.put("css", cssExts);
        HashSet<String> jsExts = new HashSet<String>();
        jsExts.addAll(Arrays.asList("js", "json", "map", "jsonld", "ts"));
        modeExtensions.put("javascript", jsExts);
        HashSet<String> xmlExts = new HashSet<String>();
        xmlExts.addAll(Arrays.asList("xml", "xsl", "xsd", "svg"));
        modeExtensions.put("xml", xmlExts);
        HashSet<String> htmlExts = new HashSet<String>();
        htmlExts.addAll(Arrays.asList("html", "htm"));
        modeExtensions.put("htmlmixed", htmlExts);
        HashSet<String> tiddlywikiExts = new HashSet<String>();
        tiddlywikiExts.add("tiddlywiki");
        modeExtensions.put("tiddlywiki", tiddlywikiExts);
        HashSet<String> tikiExts = new HashSet<String>();
        tikiExts.addAll(Arrays.asList("tiki", "wiki"));
        modeExtensions.put("tiki", tikiExts);
        HashSet<String> asciidocExts = new HashSet<String>();
        asciidocExts.add("adoc");
        modeExtensions.put("asciidoc", asciidocExts);
    }
}

