/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.autoconfigure;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sitemesh.DecoratorSelector;
import org.sitemesh.builder.SiteMeshFilterBuilder;
import org.sitemesh.config.MetaTagBasedDecoratorSelector;
import org.sitemesh.config.ObjectFactory;
import org.sitemesh.config.RequestAttributeDecoratorSelector;
import org.sitemesh.content.tagrules.TagRuleBundle;
import org.sitemesh.webapp.contentfilter.Selector;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConfigurationProperties(prefix="sitemesh.decorator")
public class SiteMeshAutoConfiguration {
    private List<HashMap<String, String>> mappings;
    @Value(value="${sitemesh.decorator.exclusions:}")
    private List<String> exclusions;
    @Value(value="${sitemesh.includeErrorPages:true}")
    boolean includeErrorPages;
    @Value(value="${sitemesh.decorator.prefix:/decorators/}")
    private String prefix;
    @Value(value="${sitemesh.decorator.metaTag:decorator}")
    private String metaTagName;
    @Value(value="${sitemesh.decorator.tagRuleBundles:}")
    private List<String> bundles;
    @Value(value="${sitemesh.decorator.attribute:#{null}}")
    private String attribute;
    @Value(value="${sitemesh.decorator.default:#{null}}")
    private String defaultPath;
    @Value(value="${sitemesh.filter.order:29}")
    private int filterOrder;

    public void setMappings(List<HashMap<String, String>> mappings) {
        this.mappings = mappings;
    }

    public static Filter makeFilter(String attribute, String defaultPath, String metaTagName, String prefix, List<HashMap<String, String>> mappings, List<String> exclusions, List<String> bundles, boolean includeErrorPages, boolean alwaysApply) {
        MetaTagBasedDecoratorSelector decoratorSelector;
        SiteMeshFilterBuilder builder = new SiteMeshFilterBuilder();
        Object object = decoratorSelector = attribute != null ? new RequestAttributeDecoratorSelector().setDecoratorAttribute(attribute) : new MetaTagBasedDecoratorSelector();
        if (defaultPath != null) {
            decoratorSelector.put("/*", new String[]{defaultPath});
        }
        builder.setCustomDecoratorSelector((DecoratorSelector)decoratorSelector.setMetaTagName(metaTagName).setPrefix(prefix));
        if (mappings != null) {
            for (Map map : mappings) {
                builder.addDecoratorPath((String)map.get("path"), (String)map.get("decorator"));
            }
        }
        if (exclusions != null) {
            for (String string : exclusions) {
                builder.addExcludedPath(string);
            }
        }
        ObjectFactory.Default objectFactory = new ObjectFactory.Default();
        for (String bundle : bundles) {
            builder.addTagRuleBundle((TagRuleBundle)objectFactory.create(bundle));
        }
        builder.setIncludeErrorPages(includeErrorPages);
        if (alwaysApply) {
            final Selector selector = builder.getSelector();
            builder.setCustomSelector(new Selector(){

                public boolean shouldBufferForContentType(String contentType, String mimeType, String encoding) {
                    return selector.shouldBufferForContentType(contentType, mimeType, encoding);
                }

                public boolean shouldAbortBufferingForHttpStatusCode(int statusCode) {
                    return selector.shouldAbortBufferingForHttpStatusCode(statusCode);
                }

                public boolean shouldBufferForRequest(HttpServletRequest request) {
                    return true;
                }

                public String excludePatternInUse(HttpServletRequest request) {
                    return selector.excludePatternInUse(request);
                }
            });
        }
        return builder.create();
    }

    @Bean
    @ConditionalOnMissingBean(name={"sitemesh"})
    public FilterRegistrationBean<Filter> sitemesh() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter(SiteMeshAutoConfiguration.makeFilter(this.attribute, this.defaultPath, this.metaTagName, this.prefix, this.mappings, this.exclusions, this.bundles, this.includeErrorPages, false));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        if (this.includeErrorPages) {
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR));
        }
        registrationBean.setOrder(this.filterOrder);
        return registrationBean;
    }
}

