/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.skife.config.Bully;
import org.skife.config.Coercible;
import org.skife.config.Config;
import org.skife.config.ConfigReplacements;
import org.skife.config.ConfigSource;
import org.skife.config.Default;
import org.skife.config.DefaultNull;
import org.skife.config.Param;
import org.skife.config.Separator;
import org.skife.config.SimplePropertyConfigSource;
import org.skife.config.cglib.proxy.Callback;
import org.skife.config.cglib.proxy.CallbackFilter;
import org.skife.config.cglib.proxy.Enhancer;
import org.skife.config.cglib.proxy.Factory;
import org.skife.config.cglib.proxy.MethodInterceptor;
import org.skife.config.cglib.proxy.MethodProxy;
import org.skife.config.cglib.proxy.NoOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationObjectFactory.class);
    private static final ConcurrentMap<Class<?>, Factory> factories = new ConcurrentHashMap();
    private final ConfigSource config;
    private final Bully bully;

    public ConfigurationObjectFactory(Properties props) {
        this(new SimplePropertyConfigSource(props));
    }

    public ConfigurationObjectFactory(ConfigSource config) {
        this.config = config;
        this.bully = new Bully();
    }

    public void addCoercible(Coercible<?> coercible) {
        this.bully.addCoercible(coercible);
    }

    public <T> T buildWithReplacements(Class<T> configClass, Map<String, String> mappedReplacements) {
        return this.internalBuild(configClass, mappedReplacements);
    }

    public <T> T build(Class<T> configClass) {
        return this.internalBuild(configClass, null);
    }

    private <T> T internalBuild(Class<T> configClass, Map<String, String> mappedReplacements) {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        HashMap<Method, Integer> slots = new HashMap<Method, Integer>();
        callbacks.add(NoOp.INSTANCE);
        int count = 1;
        Method toStringMethod = this.findToStringMethod(configClass);
        if (toStringMethod != null) {
            slots.put(toStringMethod, count++);
            callbacks.add(new ConfigMagicBeanToString(callbacks));
        }
        for (Method method : configClass.getMethods()) {
            Annotation annotation;
            if (method.isAnnotationPresent(Config.class)) {
                annotation = method.getAnnotation(Config.class);
                slots.put(method, count++);
                if (method.getParameterTypes().length > 0) {
                    if (mappedReplacements != null) {
                        throw new RuntimeException("Replacements are not supported for parameterized config methods");
                    }
                    this.buildParameterized(callbacks, method, (Config)annotation);
                    continue;
                }
                this.buildSimple(callbacks, method, (Config)annotation, mappedReplacements, null);
                continue;
            }
            if (method.isAnnotationPresent(ConfigReplacements.class)) {
                annotation = method.getAnnotation(ConfigReplacements.class);
                slots.put(method, count++);
                if ("__%%%noValue%%%__".equals(annotation.value())) {
                    Map<Object, Object> fixedMap = mappedReplacements == null ? Collections.emptyMap() : Collections.unmodifiableMap(mappedReplacements);
                    callbacks.add(new ConfigMagicFixedValue(method, "annotation: @ConfigReplacements", fixedMap, false));
                    continue;
                }
                this.buildSimple(callbacks, method, null, mappedReplacements, (ConfigReplacements)annotation);
                continue;
            }
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            throw new AbstractMethodError(String.format("Method [%s] is abstract and lacks an @Config annotation", method.toGenericString()));
        }
        if (factories.containsKey(configClass)) {
            Factory f = (Factory)factories.get(configClass);
            return configClass.cast(f.newInstance(callbacks.toArray(new Callback[callbacks.size()])));
        }
        Enhancer e = new Enhancer();
        e.setSuperclass(configClass);
        e.setCallbackFilter(new ConfigMagicCallbackFilter(slots));
        e.setCallbacks(callbacks.toArray(new Callback[callbacks.size()]));
        T rt = configClass.cast(e.create());
        factories.putIfAbsent(configClass, (Factory)rt);
        return rt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildSimple(List<Callback> callbacks, Method method, Config annotation, Map<String, String> mappedReplacements, ConfigReplacements mapAnnotation) {
        String[] forvalue;
        String assignedFrom = null;
        String[] propertyNames = new String[]{};
        String value = null;
        if (annotation != null) {
            propertyNames = annotation.value();
            if (propertyNames == null || propertyNames.length == 0) {
                throw new IllegalArgumentException("Method " + method.toGenericString() + " declares config annotation but no field name!");
            }
            for (String propertyName : propertyNames) {
                if (mappedReplacements != null) {
                    propertyName = this.applyReplacements(propertyName, mappedReplacements);
                }
                if ((value = this.config.getString(propertyName)) == null) continue;
                assignedFrom = "property: '" + propertyName + "'";
                logger.info("Assigning value [{}] for [{}] on [{}#{}()]", new Object[]{value, propertyName, method.getDeclaringClass().getName(), method.getName()});
                break;
            }
        } else {
            if (mapAnnotation == null) {
                throw new IllegalStateException("Neither @Config nor @ConfigReplacements provided, this should not be possible!");
            }
            String key = mapAnnotation.value();
            String string = value = mappedReplacements == null ? null : mappedReplacements.get(key);
            if (value != null) {
                assignedFrom = "@ConfigReplacements: key '" + key + "'";
                logger.info("Assigning mappedReplacement value [{}] for [{}] on [{}#{}()]", new Object[]{value, key, method.getDeclaringClass().getName(), method.getName()});
            }
        }
        boolean hasDefault = method.isAnnotationPresent(Default.class);
        boolean hasDefaultNull = method.isAnnotationPresent(DefaultNull.class);
        boolean hasForValue = false;
        if (hasDefault && (forvalue = method.getAnnotation(Default.class).forValues()) != null && forvalue.length > 0) {
            hasForValue = true;
        }
        if (hasDefault && hasDefaultNull) {
            throw new IllegalArgumentException(String.format("@Default and @DefaultNull present in [%s]", method.toGenericString()));
        }
        boolean useMethod = false;
        if (value == null) {
            if (hasDefault) {
                value = method.getAnnotation(Default.class).value();
                assignedFrom = "annotation: @Default";
                logger.info("Assigning default value [{}] for {} on [{}#{}()]", new Object[]{value, propertyNames, method.getDeclaringClass().getName(), method.getName()});
            } else if (hasDefaultNull) {
                logger.info("Assigning null default value for {} on [{}#{}()]", new Object[]{propertyNames, method.getDeclaringClass().getName(), method.getName()});
                assignedFrom = "annotation: @DefaultNull";
            } else {
                if (Modifier.isAbstract(method.getModifiers())) throw new IllegalArgumentException(String.format("No value present for '%s' in [%s]", this.prettyPrint(propertyNames, mappedReplacements), method.toGenericString()));
                useMethod = true;
                assignedFrom = "method: '" + method.getName() + "()'";
                logger.info("Using method itself for {} on [{}#{}()]", new Object[]{propertyNames, method.getDeclaringClass().getName(), method.getName()});
            }
        } else if (value != null && hasForValue) {
            String[] forvalue2;
            for (String val : forvalue2 = method.getAnnotation(Default.class).forValues()) {
                if (!value.equalsIgnoreCase(val)) continue;
                value = method.getAnnotation(Default.class).value();
                assignedFrom = "annotation: @Default";
                logger.info("Assigning default for_value [{}] for {} on [{}#{}()]", new Object[]{value, propertyNames, method.getDeclaringClass().getName(), method.getName()});
                break;
            }
        }
        Object finalValue = this.bully.coerce(method.getGenericReturnType(), value, method.getAnnotation(Separator.class));
        callbacks.add(new ConfigMagicFixedValue(method, assignedFrom, finalValue, useMethod));
    }

    private String applyReplacements(String propertyName, Map<String, String> mappedReplacements) {
        for (String key : mappedReplacements.keySet()) {
            String token = this.makeToken(key);
            String replacement = mappedReplacements.get(key);
            propertyName = propertyName.replace(token, replacement);
        }
        return propertyName;
    }

    private void buildParameterized(List<Callback> callbacks, Method method, Config annotation) {
        String defaultValue = null;
        boolean hasDefault = method.isAnnotationPresent(Default.class);
        boolean hasDefaultNull = method.isAnnotationPresent(DefaultNull.class);
        if (hasDefault && hasDefaultNull) {
            throw new IllegalArgumentException(String.format("@Default and @DefaultNull present in [%s]", method.toGenericString()));
        }
        if (hasDefault) {
            defaultValue = method.getAnnotation(Default.class).value();
        } else if (!hasDefaultNull) {
            throw new IllegalArgumentException(String.format("No value present for '%s' in [%s]", this.prettyPrint(annotation.value(), null), method.toGenericString()));
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<String> paramTokenList = new ArrayList<String>();
        Annotation[][] annotationArray = parameterAnnotations;
        int n = annotationArray.length;
        block0: for (int i = 0; i < n; ++i) {
            Annotation[] parameterTab;
            for (Annotation parameter : parameterTab = annotationArray[i]) {
                if (!parameter.annotationType().equals(Param.class)) continue;
                Param paramAnnotation = (Param)parameter;
                paramTokenList.add(this.makeToken(paramAnnotation.value()));
                continue block0;
            }
        }
        if (paramTokenList.size() != method.getParameterTypes().length) {
            throw new RuntimeException(String.format("Method [%s] is missing one or more @Param annotations", method.toGenericString()));
        }
        Object bulliedDefaultValue = this.bully.coerce(method.getGenericReturnType(), defaultValue, method.getAnnotation(Separator.class));
        String[] annotationValues = annotation.value();
        if (annotationValues == null || annotationValues.length == 0) {
            throw new IllegalArgumentException("Method " + method.toGenericString() + " declares config annotation but no field name!");
        }
        callbacks.add(new ConfigMagicMethodInterceptor(method, this.config, annotationValues, paramTokenList, this.bully, bulliedDefaultValue));
    }

    private String makeToken(String temp) {
        return "${" + temp + "}";
    }

    private String prettyPrint(String[] values, Map<String, String> mappedReplacements) {
        int i;
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        if (mappedReplacements != null && mappedReplacements.size() > 0) {
            sb.append(" translated to [");
            for (i = 0; i < values.length; ++i) {
                sb.append(this.applyReplacements(values[i], mappedReplacements));
                if (i >= values.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private Method findToStringMethod(Class<?> clazz) {
        try {
            return clazz.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            try {
                return Object.class.getMethod("toString", new Class[0]);
            }
            catch (NoSuchMethodException nsme2) {
                throw new IllegalStateException("Could not intercept toString method!", nsme);
            }
        }
    }

    private static final class ConfigMagicBeanToString
    implements MethodInterceptor {
        private final List<Callback> callbacks;
        private transient String toStringValue = null;

        private ConfigMagicBeanToString(List<Callback> callbacks) {
            this.callbacks = callbacks;
        }

        @Override
        public Object intercept(Object o, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            if (this.toStringValue == null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < this.callbacks.size(); ++i) {
                    sb.append(this.callbacks.get(i).toString());
                    if (i >= this.callbacks.size() - 1) continue;
                    sb.append("\n");
                }
                this.toStringValue = sb.toString();
            }
            return this.toStringValue;
        }
    }

    private static final class ConfigMagicMethodInterceptor
    implements MethodInterceptor {
        private final Method method;
        private final ConfigSource config;
        private final String[] properties;
        private final Bully bully;
        private final Object defaultValue;
        private final List<String> paramTokenList;
        private transient String toStringValue = null;

        private ConfigMagicMethodInterceptor(Method method, ConfigSource config, String[] properties, List<String> paramTokenList, Bully bully, Object defaultValue) {
            this.method = method;
            this.config = config;
            this.properties = properties;
            this.paramTokenList = paramTokenList;
            this.bully = bully;
            this.defaultValue = defaultValue;
        }

        @Override
        public Object intercept(Object o, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            for (String property : this.properties) {
                if (args.length == this.paramTokenList.size()) {
                    for (int i = 0; i < args.length; ++i) {
                        property = property.replace(this.paramTokenList.get(i), String.valueOf(args[i]));
                    }
                    String value = this.config.getString(property);
                    if (value == null) continue;
                    logger.info("Assigning value [{}] for [{}] on [{}#{}()]", new Object[]{value, property, method.getDeclaringClass().getName(), method.getName()});
                    return this.bully.coerce(method.getGenericReturnType(), value, method.getAnnotation(Separator.class));
                }
                throw new IllegalStateException("Argument list doesn't match @Param list");
            }
            logger.info("Assigning default value [{}] for {} on [{}#{}()]", new Object[]{this.defaultValue, this.properties, method.getDeclaringClass().getName(), method.getName()});
            return this.defaultValue;
        }

        public String toString() {
            if (this.toStringValue == null) {
                this.toStringValue = this.method.getName() + ": " + super.toString();
            }
            return this.toStringValue;
        }
    }

    private static final class ConfigMagicCallbackFilter
    implements CallbackFilter {
        private final Map<Method, Integer> slots;

        private ConfigMagicCallbackFilter(Map<Method, Integer> slots) {
            this.slots = slots;
        }

        @Override
        public int accept(Method method) {
            return this.slots.containsKey(method) ? this.slots.get(method) : 0;
        }
    }

    private static final class ConfigMagicFixedValue
    implements MethodInterceptor {
        private final Method method;
        private final String assignedFrom;
        private final Handler handler;
        private transient String toStringValue = null;

        private ConfigMagicFixedValue(Method method, String assignedFrom, Object value, boolean callSuper) {
            this.method = method;
            this.assignedFrom = assignedFrom;
            this.handler = callSuper ? new InvokeSuperHandler() : new FixedValueHandler(value);
        }

        @Override
        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            return this.handler.handle(methodProxy, o, objects);
        }

        public String toString() {
            if (this.toStringValue == null) {
                StringBuilder sb = new StringBuilder(this.method.getName());
                sb.append("(): ");
                sb.append(this.assignedFrom);
                sb.append(", ");
                sb.append(this.handler.toString());
                this.toStringValue = sb.toString();
            }
            return this.toStringValue;
        }

        private static class FixedValueHandler
        implements Handler {
            private final Object finalValue;
            private transient String toStringValue = null;

            public FixedValueHandler(Object finalValue) {
                this.finalValue = finalValue;
            }

            @Override
            public Object handle(MethodProxy m, Object o, Object[] args) throws Throwable {
                return this.finalValue;
            }

            public String toString() {
                if (this.toStringValue == null) {
                    StringBuilder sb = new StringBuilder("value: ");
                    if (this.finalValue != null) {
                        sb.append(this.finalValue.toString());
                        sb.append(", class: ");
                        sb.append(this.finalValue.getClass().getName());
                    } else {
                        sb.append("<null>");
                    }
                    this.toStringValue = sb.toString();
                }
                return this.toStringValue;
            }
        }

        private static class InvokeSuperHandler
        implements Handler {
            private InvokeSuperHandler() {
            }

            @Override
            public Object handle(MethodProxy m, Object o, Object[] args) throws Throwable {
                return m.invokeSuper(o, args);
            }
        }

        private static interface Handler {
            public Object handle(MethodProxy var1, Object var2, Object[] var3) throws Throwable;
        }
    }
}

