/*
 * Decompiled with CFR 0.152.
 */
package skinny.nlp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.util.control.NonFatal$;
import skinny.nlp.KuromojiJapaneseAnalyzer;
import skinny.nlp.SkinnyJapaneseAnalyzer;
import skinny.util.LoanPattern$;

public final class SkinnyJapaneseAnalyzerFactory$ {
    public static SkinnyJapaneseAnalyzerFactory$ MODULE$;
    private boolean kuromojiNotFound;
    private volatile boolean bitmap$0;

    static {
        new SkinnyJapaneseAnalyzerFactory$();
    }

    public void ensureKuromojiExistence() {
        if (this.kuromojiNotFound()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Kuromoji Analyzer Required\n          |\n          |-------------------------------------------\n          |\n          | ***** Kuromoji Analyzer Required *****\n          |\n          | Japanese converters (katakana, hiragana, romaji) requires Kuromoji analyzer from Apache Lucene. http://lucene.apache.org/\n          |\n          | Add the following dependency to your build.sbt.\n          |\n          |   libraryDependencies += \"org.apache.lucene\" % \"lucene-analyzers-kuromoji\" % \"<luceneLatestVersion>\"\n          |\n          |-------------------------------------------\n          |")).stripMargin());
        }
    }

    private boolean kuromojiNotFound$lzycompute() {
        SkinnyJapaneseAnalyzerFactory$ skinnyJapaneseAnalyzerFactory$ = this;
        synchronized (skinnyJapaneseAnalyzerFactory$) {
            if (!this.bitmap$0) {
                this.kuromojiNotFound = SkinnyJapaneseAnalyzerFactory$.liftedTree1$1();
                this.bitmap$0 = true;
            }
        }
        return this.kuromojiNotFound;
    }

    public boolean kuromojiNotFound() {
        return !this.bitmap$0 ? this.kuromojiNotFound$lzycompute() : this.kuromojiNotFound;
    }

    public SkinnyJapaneseAnalyzer create(String dictionaryText) {
        UserDictionary dictionary = (UserDictionary)LoanPattern$.MODULE$.using((Object)new ByteArrayInputStream(dictionaryText.getBytes()), (Function1 & Serializable & scala.Serializable)stream -> (UserDictionary)LoanPattern$.MODULE$.using((Object)new InputStreamReader((InputStream)stream), (Function1 & Serializable & scala.Serializable)reader -> UserDictionary.open((Reader)reader)));
        return this.create(dictionary);
    }

    public SkinnyJapaneseAnalyzer create(UserDictionary userDictionary) {
        this.ensureKuromojiExistence();
        return new KuromojiJapaneseAnalyzer(new JapaneseAnalyzer(userDictionary, JapaneseTokenizer.Mode.NORMAL, new CharArraySet(0, true), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().empty()).asJava()));
    }

    public UserDictionary create$default$1() {
        return null;
    }

    private static final boolean liftedTree1$1() {
        boolean bl;
        try {
            Class.forName("org.apache.lucene.analysis.ja.JapaneseAnalyzer");
            bl = false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = true;
            bl = bl2;
        }
        return bl;
    }

    private SkinnyJapaneseAnalyzerFactory$() {
        MODULE$ = this;
    }
}

