/*
 * Decompiled with CFR 0.152.
 */
package skinny.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.AppenderBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Marker;
import skinny.logging.logback.StringUtils;

public class LevelRemappingAppender
extends AppenderBase<ILoggingEvent> {
    private static final Map<Level, Level> DEFAULT_REMAPS = Collections.singletonMap(Level.INFO, Level.DEBUG);
    private String destinationLogger = "ROOT";
    private Map<Level, Level> remapLevels = DEFAULT_REMAPS;

    protected void append(ILoggingEvent iLoggingEvent) {
        AppendableLogger appendableLogger = this.getLogger(this.destinationLogger);
        Level level = this.remapLevels.get(iLoggingEvent.getLevel());
        appendableLogger.callAppenders((ILoggingEvent)(level == null ? iLoggingEvent : new RemappedLoggingEvent(iLoggingEvent)));
    }

    protected AppendableLogger getLogger(String string) {
        LoggerContext loggerContext = (LoggerContext)this.context;
        return new AppendableLogger(loggerContext.getLogger(string));
    }

    public void setDestinationLogger(String string) {
        this.destinationLogger = string;
    }

    public void setRemapLevels(String string) {
        this.remapLevels = new HashMap<Level, Level>();
        for (String string2 : StringUtils.commaDelimitedListToStringArray(string)) {
            String[] stringArray = StringUtils.split(string2, "->");
            this.remapLevels.put(Level.toLevel((String)stringArray[0]), Level.toLevel((String)stringArray[1]));
        }
    }

    private class RemappedLoggingEvent
    implements ILoggingEvent {
        private final ILoggingEvent event;

        public RemappedLoggingEvent(ILoggingEvent iLoggingEvent) {
            this.event = iLoggingEvent;
        }

        public String getThreadName() {
            return this.event.getThreadName();
        }

        public Level getLevel() {
            Level level = (Level)LevelRemappingAppender.this.remapLevels.get(this.event.getLevel());
            return level == null ? this.event.getLevel() : level;
        }

        public String getMessage() {
            return this.event.getMessage();
        }

        public Object[] getArgumentArray() {
            return this.event.getArgumentArray();
        }

        public String getFormattedMessage() {
            return this.event.getFormattedMessage();
        }

        public String getLoggerName() {
            return this.event.getLoggerName();
        }

        public LoggerContextVO getLoggerContextVO() {
            return this.event.getLoggerContextVO();
        }

        public IThrowableProxy getThrowableProxy() {
            return this.event.getThrowableProxy();
        }

        public StackTraceElement[] getCallerData() {
            return this.event.getCallerData();
        }

        public boolean hasCallerData() {
            return this.event.hasCallerData();
        }

        public Marker getMarker() {
            return this.event.getMarker();
        }

        public Map<String, String> getMDCPropertyMap() {
            return this.event.getMDCPropertyMap();
        }

        @Deprecated
        public Map<String, String> getMdc() {
            return this.event.getMdc();
        }

        public long getTimeStamp() {
            return this.event.getTimeStamp();
        }

        public void prepareForDeferredProcessing() {
            this.event.prepareForDeferredProcessing();
        }
    }

    protected static class AppendableLogger {
        private Logger logger;

        public AppendableLogger(Logger logger) {
            this.logger = logger;
        }

        public void callAppenders(ILoggingEvent iLoggingEvent) {
            if (this.logger.isEnabledFor(iLoggingEvent.getLevel())) {
                this.logger.callAppenders(iLoggingEvent);
            }
        }
    }
}

