/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.bridge;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JBridgeHandler
extends Handler {
    private static final String FQCN = java.util.logging.Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();

    public static void install() {
        LogManager.getLogManager().reset();
        LogManager.getLogManager().getLogger("").addHandler(new SLF4JBridgeHandler());
    }

    public static void uninstall() throws Exception {
        LogManager.getLogManager().readConfiguration();
    }

    public void close() {
    }

    public void flush() {
    }

    protected Logger getSLF4JLogger(LogRecord record) {
        String name = record.getLoggerName();
        if (name == null) {
            name = UNKNOWN_LOGGER_NAME;
        }
        return LoggerFactory.getLogger((String)name);
    }

    protected void callLocationAwareLogger(LocationAwareLogger lal, LogRecord record) {
        int julLevelValue = record.getLevel().intValue();
        int slf4jLevel = julLevelValue <= TRACE_LEVEL_THRESHOLD ? 0 : (julLevelValue <= DEBUG_LEVEL_THRESHOLD ? 10 : (julLevelValue <= INFO_LEVEL_THRESHOLD ? 20 : (julLevelValue <= WARN_LEVEL_THRESHOLD ? 30 : 40)));
        lal.log(null, FQCN, slf4jLevel, record.getMessage(), record.getThrown());
    }

    protected void callPlainSLF4JLogger(Logger slf4jLogger, LogRecord record) {
        int julLevelValue = record.getLevel().intValue();
        if (julLevelValue <= TRACE_LEVEL_THRESHOLD) {
            slf4jLogger.trace(record.getMessage(), record.getThrown());
        } else if (julLevelValue <= DEBUG_LEVEL_THRESHOLD) {
            slf4jLogger.debug(record.getMessage(), record.getThrown());
        } else if (julLevelValue <= INFO_LEVEL_THRESHOLD) {
            slf4jLogger.info(record.getMessage(), record.getThrown());
        } else if (julLevelValue <= WARN_LEVEL_THRESHOLD) {
            slf4jLogger.warn(record.getMessage(), record.getThrown());
        } else {
            slf4jLogger.error(record.getMessage(), record.getThrown());
        }
    }

    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        Logger slf4jLogger = this.getSLF4JLogger(record);
        String message = record.getMessage();
        if (message == null) {
            return;
        }
        if (slf4jLogger instanceof LocationAwareLogger) {
            this.callLocationAwareLogger((LocationAwareLogger)slf4jLogger, record);
        } else {
            this.callPlainSLF4JLogger(slf4jLogger, record);
        }
    }
}

