/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.Iterator;
import junit.framework.TestCase;
import org.slf4j.Differentiator;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;

public class BasicMarkerTest
extends TestCase {
    static final String BLUE_STR = "BLUE";
    static final String RED_STR = "RED";
    static final String GREEN_STR = "GREEN";
    static final String COMP_STR = "COMP";
    static final String MULTI_COMP_STR = "MULTI_COMP";
    static final String PARENT_MARKER_STR = "PARENT_MARKER";
    static final String CHILD_MARKER_STR = "CHILD_MARKER";
    static final String NOT_CONTAINED_MARKER_STR = "NOT_CONTAINED";
    final IMarkerFactory factory;
    final Marker blue;
    final Marker red;
    final Marker green;
    final Marker comp;
    final Marker multiComp;
    short diff = Differentiator.getDiffentiator();

    public BasicMarkerTest() {
        this.factory = new BasicMarkerFactory();
        this.blue = this.factory.getMarker(BLUE_STR);
        this.red = this.factory.getMarker(RED_STR);
        this.green = this.factory.getMarker(GREEN_STR);
        this.comp = this.factory.getMarker(COMP_STR);
        this.comp.add(this.blue);
        this.multiComp = this.factory.getMarker(MULTI_COMP_STR);
        this.multiComp.add(this.green);
        this.multiComp.add(this.comp);
    }

    public void testPrimitive() {
        BasicMarkerTest.assertEquals((String)BLUE_STR, (String)this.blue.getName());
        BasicMarkerTest.assertTrue((boolean)this.blue.contains(this.blue));
        Marker blue2 = this.factory.getMarker(BLUE_STR);
        BasicMarkerTest.assertEquals((String)BLUE_STR, (String)blue2.getName());
        BasicMarkerTest.assertEquals((Object)this.blue, (Object)blue2);
        BasicMarkerTest.assertTrue((boolean)this.blue.contains(blue2));
        BasicMarkerTest.assertTrue((boolean)blue2.contains(this.blue));
    }

    public void testPrimitiveByName() {
        BasicMarkerTest.assertTrue((boolean)this.blue.contains(BLUE_STR));
    }

    public void testComposite() {
        BasicMarkerTest.assertTrue((boolean)this.comp.contains(this.comp));
        BasicMarkerTest.assertTrue((boolean)this.comp.contains(this.blue));
    }

    public void testCompositeByName() {
        BasicMarkerTest.assertTrue((boolean)this.comp.contains(COMP_STR));
        BasicMarkerTest.assertTrue((boolean)this.comp.contains(BLUE_STR));
    }

    public void testMultiComposite() {
        BasicMarkerTest.assertTrue((boolean)this.multiComp.contains(this.comp));
        BasicMarkerTest.assertTrue((boolean)this.multiComp.contains(this.blue));
        BasicMarkerTest.assertTrue((boolean)this.multiComp.contains(this.green));
        BasicMarkerTest.assertFalse((boolean)this.multiComp.contains(this.red));
    }

    public void testMultiCompositeByName() {
        BasicMarkerTest.assertTrue((boolean)this.multiComp.contains(COMP_STR));
        BasicMarkerTest.assertTrue((boolean)this.multiComp.contains(BLUE_STR));
        BasicMarkerTest.assertTrue((boolean)this.multiComp.contains(GREEN_STR));
        BasicMarkerTest.assertFalse((boolean)this.multiComp.contains(RED_STR));
    }

    public void testMultiAdd() {
        Marker parent = this.factory.getMarker(PARENT_MARKER_STR);
        Marker child = this.factory.getMarker(CHILD_MARKER_STR);
        for (int i = 0; i < 10; ++i) {
            parent.add(child);
        }
        Iterator iterator = parent.iterator();
        BasicMarkerTest.assertTrue((boolean)iterator.hasNext());
        BasicMarkerTest.assertEquals((String)CHILD_MARKER_STR, (String)iterator.next().toString());
        BasicMarkerTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testAddRemove() {
        String NEW_PREFIX = "NEW_";
        Marker parent = this.factory.getMarker("NEW_PARENT_MARKER");
        Marker child = this.factory.getMarker("NEW_CHILD_MARKER");
        BasicMarkerTest.assertFalse((boolean)parent.contains(child));
        BasicMarkerTest.assertFalse((boolean)parent.contains("NEW_CHILD_MARKER"));
        BasicMarkerTest.assertFalse((boolean)parent.remove(child));
        parent.add(child);
        BasicMarkerTest.assertTrue((boolean)parent.contains(child));
        BasicMarkerTest.assertTrue((boolean)parent.contains("NEW_CHILD_MARKER"));
        BasicMarkerTest.assertTrue((boolean)parent.remove(child));
        BasicMarkerTest.assertFalse((boolean)parent.contains(child));
        BasicMarkerTest.assertFalse((boolean)parent.contains("NEW_CHILD_MARKER"));
        BasicMarkerTest.assertFalse((boolean)parent.remove(child));
    }

    public void testSelfRecursion() {
        String diffPrefix = "NEW_" + this.diff;
        String PARENT_NAME = diffPrefix + PARENT_MARKER_STR;
        String NOT_CONTAINED_NAME = diffPrefix + NOT_CONTAINED_MARKER_STR;
        Marker parent = this.factory.getMarker(PARENT_NAME);
        Marker notContained = this.factory.getMarker(NOT_CONTAINED_NAME);
        parent.add(parent);
        BasicMarkerTest.assertTrue((boolean)parent.contains(parent));
        BasicMarkerTest.assertTrue((boolean)parent.contains(PARENT_NAME));
        BasicMarkerTest.assertFalse((boolean)parent.contains(notContained));
        BasicMarkerTest.assertFalse((boolean)parent.contains(NOT_CONTAINED_MARKER_STR));
    }

    public void testIndirectRecursion() {
        String diffPrefix = "NEW_" + this.diff;
        String PARENT_NAME = diffPrefix + PARENT_MARKER_STR;
        String CHILD_NAME = diffPrefix + CHILD_MARKER_STR;
        String NOT_CONTAINED_NAME = diffPrefix + NOT_CONTAINED_MARKER_STR;
        Marker parent = this.factory.getMarker(PARENT_NAME);
        Marker child = this.factory.getMarker(CHILD_NAME);
        Marker notContained = this.factory.getMarker(NOT_CONTAINED_NAME);
        parent.add(child);
        child.add(parent);
        BasicMarkerTest.assertTrue((boolean)parent.contains(parent));
        BasicMarkerTest.assertTrue((boolean)parent.contains(child));
        BasicMarkerTest.assertTrue((boolean)parent.contains(PARENT_NAME));
        BasicMarkerTest.assertTrue((boolean)parent.contains(CHILD_NAME));
        BasicMarkerTest.assertFalse((boolean)parent.contains(notContained));
        BasicMarkerTest.assertFalse((boolean)parent.contains(NOT_CONTAINED_MARKER_STR));
    }

    public void testHomonyms() {
        String diffPrefix = "homonym" + this.diff;
        String PARENT_NAME = diffPrefix + PARENT_MARKER_STR;
        String CHILD_NAME = diffPrefix + CHILD_MARKER_STR;
        Marker parent = this.factory.getMarker(PARENT_NAME);
        Marker child = this.factory.getMarker(CHILD_NAME);
        parent.add(child);
        BasicMarkerFactory otherFactory = new BasicMarkerFactory();
        Marker otherParent = otherFactory.getMarker(PARENT_NAME);
        Marker otherChild = otherFactory.getMarker(CHILD_NAME);
        BasicMarkerTest.assertTrue((boolean)parent.contains(otherParent));
        BasicMarkerTest.assertTrue((boolean)parent.contains(otherChild));
        BasicMarkerTest.assertTrue((boolean)parent.remove(otherChild));
    }
}

