/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.slf4j.helpers.BubbleSort;

public class BubbleSortTest
extends TestCase {
    public void testSmoke() {
        int[] a = new int[]{5, 3, 2, 7};
        BubbleSort.sort(a);
        int i = 0;
        BubbleSortTest.assertEquals((int)2, (int)a[i++]);
        BubbleSortTest.assertEquals((int)3, (int)a[i++]);
        BubbleSortTest.assertEquals((int)5, (int)a[i++]);
        BubbleSortTest.assertEquals((int)7, (int)a[i++]);
    }

    public void testEmpty() {
        int[] a = new int[]{};
        BubbleSort.sort(a);
    }

    public void testSorted() {
        int[] a = new int[]{3, 30, 300, 3000};
        BubbleSort.sort(a);
        int i = 0;
        BubbleSortTest.assertEquals((int)3, (int)a[i++]);
        BubbleSortTest.assertEquals((int)30, (int)a[i++]);
        BubbleSortTest.assertEquals((int)300, (int)a[i++]);
        BubbleSortTest.assertEquals((int)3000, (int)a[i++]);
    }

    public void testInverted() {
        int[] a = new int[]{3000, 300, 30, 3};
        BubbleSort.sort(a);
        int i = 0;
        BubbleSortTest.assertEquals((int)3, (int)a[i++]);
        BubbleSortTest.assertEquals((int)30, (int)a[i++]);
        BubbleSortTest.assertEquals((int)300, (int)a[i++]);
        BubbleSortTest.assertEquals((int)3000, (int)a[i++]);
    }

    public void testWithSameEntry() {
        int[] a = new int[]{10, 20, 10, 20};
        BubbleSort.sort(a);
        int i = 0;
        BubbleSortTest.assertEquals((int)10, (int)a[i++]);
        BubbleSortTest.assertEquals((int)10, (int)a[i++]);
        BubbleSortTest.assertEquals((int)20, (int)a[i++]);
        BubbleSortTest.assertEquals((int)20, (int)a[i++]);
    }

    public void testRandom() {
        int len = 100;
        Random random = new Random(156L);
        int[] a = new int[len];
        int[] witness = new int[len];
        for (int i = 0; i < len; ++i) {
            int r;
            a[i] = r = random.nextInt();
            witness[i] = r;
        }
        BubbleSort.sort(a);
        Arrays.sort(witness);
        BubbleSortTest.assertTrue((boolean)Arrays.equals(witness, a));
    }
}

