/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.helpers.SubstituteLogger;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class SubstituteLoggerFactoryTest {
    private SubstituteLoggerFactory factory = new SubstituteLoggerFactory();

    @Test
    public void testFactory() {
        Logger log = this.factory.getLogger("foo");
        Assert.assertNotNull((Object)log);
        Logger log2 = this.factory.getLogger("foo");
        Assert.assertTrue((String)"Loggers with same name must be same", (log == log2 ? 1 : 0) != 0);
    }

    @Test
    public void testLoggerNameList() {
        this.factory.getLogger("foo1");
        this.factory.getLogger("foo2");
        HashSet<String> expectedNames = new HashSet<String>(Arrays.asList("foo1", "foo2"));
        HashSet actualNames = new HashSet(this.factory.getLoggerNames());
        Assert.assertEquals(expectedNames, actualNames);
    }

    @Test
    public void testLoggers() {
        this.factory.getLogger("foo1");
        this.factory.getLogger("foo2");
        HashSet<String> expectedNames = new HashSet<String>(Arrays.asList("foo1", "foo2"));
        HashSet<String> actualNames = new HashSet<String>();
        for (SubstituteLogger slog : this.factory.getLoggers()) {
            actualNames.add(slog.getName());
        }
        Assert.assertEquals(expectedNames, actualNames);
    }
}

