/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.EventRecodingLogger;
import org.slf4j.helpers.SubstituteLogger;

public class SubstitutableLoggerTest {
    private static final Set<String> EXCLUDED_METHODS = new HashSet<String>(Arrays.asList("getName", "makeLoggingEventBuilder", "atTrace", "atDebug", "atInfo", "atWarn", "atError"));

    @Test
    public void testDelegate() throws Exception {
        SubstituteLogger substituteLogger = new SubstituteLogger("foo", null, false);
        Assert.assertTrue((boolean)(substituteLogger.delegate() instanceof EventRecodingLogger));
        Set<String> expectedMethodSignatures = SubstitutableLoggerTest.determineMethodSignatures(Logger.class);
        LoggerInvocationHandler ih = new LoggerInvocationHandler();
        Logger proxyLogger = (Logger)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)ih);
        substituteLogger.setDelegate(proxyLogger);
        this.invokeMethods((Logger)substituteLogger);
        expectedMethodSignatures.removeAll(ih.getInvokedMethodSignatures());
        if (!expectedMethodSignatures.isEmpty()) {
            Assert.fail((String)("Following methods are not delegated " + expectedMethodSignatures.toString()));
        }
    }

    private void invokeMethods(Logger proxyLogger) throws InvocationTargetException, IllegalAccessException {
        for (Method m : Logger.class.getDeclaredMethods()) {
            if (EXCLUDED_METHODS.contains(m.getName())) continue;
            m.invoke((Object)proxyLogger, new Object[m.getParameterTypes().length]);
        }
    }

    private static Set<String> determineMethodSignatures(Class<Logger> loggerClass) {
        HashSet<String> methodSignatures = new HashSet<String>();
        for (Method m : loggerClass.getDeclaredMethods()) {
            if (EXCLUDED_METHODS.contains(m.getName())) continue;
            methodSignatures.add(SubstitutableLoggerTest.getMethodSignature(m));
        }
        return methodSignatures;
    }

    private static String getMethodSignature(Method m) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(m.getName());
        for (Class<?> clazz : m.getParameterTypes()) {
            result.add(clazz.getSimpleName());
        }
        return ((Object)result).toString();
    }

    private class LoggerInvocationHandler
    implements InvocationHandler {
        private final Set<String> invokedMethodSignatures = new HashSet<String>();

        private LoggerInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.invokedMethodSignatures.add(SubstitutableLoggerTest.getMethodSignature(method));
            if (method.getName().startsWith("is")) {
                return true;
            }
            return null;
        }

        public Set<String> getInvokedMethodSignatures() {
            return this.invokedMethodSignatures;
        }
    }
}

