/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.basicTests;

import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.helpers.BasicMarker;
import org.slf4j.helpers.NOPLogger;

public class NoBindingTest {
    int diff = new Random().nextInt(10000);

    @Before
    public void setUp() throws Exception {
        System.setProperty("slf4j.internal.verbosity", "debug");
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("slf4j.internal.verbosity");
    }

    @Test
    public void testLogger() {
        Logger logger = LoggerFactory.getLogger(NoBindingTest.class);
        logger.debug("hello" + this.diff);
        Assert.assertTrue((boolean)(logger instanceof NOPLogger));
    }

    @Test
    public void testMDC() {
        MDC.put((String)("k" + this.diff), (String)"v");
        Assert.assertNull((Object)MDC.get((String)"k"));
    }

    @Test
    public void testMarker() {
        Marker m = MarkerFactory.getMarker((String)("a" + this.diff));
        Assert.assertTrue((boolean)(m instanceof BasicMarker));
    }
}

