/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.EventRecordingLogger;
import org.slf4j.helpers.SubstituteLogger;

public class SubstitutableLoggerTest {
    private static final Set<String> EXCLUDED_METHODS = new HashSet<String>(Arrays.asList("getName"));

    @Test
    public void delegateIsInvokedTest() throws Exception {
        SubstituteLogger substituteLogger = new SubstituteLogger("foo", null, false);
        Assert.assertTrue((boolean)(substituteLogger.delegate() instanceof EventRecordingLogger));
        Set<String> expectedMethodSignatures = SubstitutableLoggerTest.determineMethodSignatures(Logger.class);
        LoggerInvocationHandler loggerInvocationHandler = new LoggerInvocationHandler();
        Logger proxyLogger = (Logger)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)loggerInvocationHandler);
        substituteLogger.setDelegate(proxyLogger);
        this.invokeAllMethodsOf((Logger)substituteLogger);
        expectedMethodSignatures.removeAll(loggerInvocationHandler.getInvokedMethodSignatures());
        if (!expectedMethodSignatures.isEmpty()) {
            Assert.fail((String)("Following methods are not delegated " + expectedMethodSignatures.toString()));
        }
    }

    private void invokeAllMethodsOf(Logger logger) throws InvocationTargetException, IllegalAccessException {
        for (Method m : Logger.class.getDeclaredMethods()) {
            if (EXCLUDED_METHODS.contains(m.getName())) continue;
            m.invoke((Object)logger, new Object[m.getParameterTypes().length]);
        }
    }

    private static Set<String> determineMethodSignatures(Class<Logger> loggerClass) {
        HashSet<String> methodSignatures = new HashSet<String>();
        for (Method m : loggerClass.getDeclaredMethods()) {
            if (EXCLUDED_METHODS.contains(m.getName())) continue;
            methodSignatures.add(m.toString());
        }
        return methodSignatures;
    }

    private class LoggerInvocationHandler
    implements InvocationHandler {
        private final Set<String> invokedMethodSignatures = new HashSet<String>();

        private LoggerInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.invokedMethodSignatures.add(method.toString());
            if (method.getName().startsWith("is")) {
                return true;
            }
            return null;
        }

        public Set<String> getInvokedMethodSignatures() {
            return this.invokedMethodSignatures;
        }
    }
}

