/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.converter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.converter.ProjectConverter;

public class ConverterFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -1535809047324769347L;
    private JButton butCancel;
    private JButton butNext;
    private JComboBox combo;
    private JPanel principalPan;
    private JPanel conversionPan;
    private JTextArea console;
    private JScrollPane consolePan;
    private String[] conversionMode = new String[]{"JCL to SLF4J", "Log4J to SLF4J"};

    public ConverterFrame() {
        this.buildFrame();
        ConverterStream printStream = new ConverterStream(System.out);
        printStream.setOut(this.console);
        System.setOut(printStream);
    }

    private void buildFrame() {
        this.setTitle("SLF4J CONVERTER");
        this.setLocationRelativeTo(null);
        this.setPreferredSize(new Dimension(512, 384));
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.buildComponents();
    }

    private void buildComponents() {
        this.principalPan = new JPanel();
        this.principalPan.setLayout(new BorderLayout());
        this.conversionPan = new JPanel(new GridLayout(2, 2, 10, 10));
        JLabel lab = new JLabel("Conversion Mode");
        this.conversionPan.add(lab);
        this.combo = new JComboBox<String>(this.conversionMode);
        this.conversionPan.add(this.combo);
        this.butCancel = new JButton("Cancel");
        this.butCancel.addActionListener(this);
        this.conversionPan.add(this.butCancel);
        this.butNext = new JButton("Next");
        this.butNext.addActionListener(this);
        this.conversionPan.add(this.butNext);
        this.consolePan = new JScrollPane();
        this.console = new JTextArea();
        this.console.setEditable(false);
        this.console.setLineWrap(true);
        this.console.setMargin(new Insets(5, 5, 5, 5));
        this.consolePan.setViewportView(this.console);
        this.principalPan.add((Component)this.conversionPan, "North");
        this.principalPan.add((Component)this.consolePan, "Center");
        this.setContentPane(this.principalPan);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butCancel) {
            this.dispose();
        } else if (e.getSource() == this.butNext) {
            this.showFolderSelector();
        }
    }

    private void showFolderSelector() {
        JFileChooser selector = new JFileChooser();
        selector.setDialogTitle("Source folder selector");
        selector.setFileSelectionMode(1);
        int res = selector.showOpenDialog(this);
        if (res == 0) {
            File folder = selector.getSelectedFile();
            ProjectConverter converter = new ProjectConverter(this.combo.getSelectedIndex());
            this.showConfirmDialog(converter, folder);
        }
    }

    private void showConfirmDialog(ProjectConverter converter, File folder) {
        int reponse = JOptionPane.showConfirmDialog(null, "RUNNING CONVERTER WILL REPLACE JAVA FILES INTO " + folder, "CONVERSION CONFIRMATION", 0);
        if (reponse == 0) {
            converter.convertProject(folder);
            converter.printException();
        } else {
            this.dispose();
        }
    }

    private class ConverterStream
    extends PrintStream {
        JTextArea console;

        public ConverterStream(OutputStream out) {
            super(out);
        }

        public void setOut(JTextArea console) {
            this.console = console;
        }

        public void println(String string) {
            this.console.setText(this.console.getText() + string + "\n");
        }
    }
}

