/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.converter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.slf4j.converter.line.LineConverter;
import org.slf4j.converter.line.RuleSet;

public class InplaceFileConverter {
    static final int BUFFER_LEN = 8192;
    final LineConverter lineConverter;
    final String lineTerminator;

    InplaceFileConverter(RuleSet ruleSet) {
        this.lineConverter = new LineConverter(ruleSet);
        this.lineTerminator = System.getProperty("line.separator");
    }

    private byte[] readIntoByteArray(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int n = 0;
        byte[] buffer = new byte[8192];
        while ((n = fis.read(buffer)) != -1) {
            baos.write(buffer, 0, n);
        }
        fis.close();
        return baos.toByteArray();
    }

    void convert(File file) throws IOException {
        byte[] originalBytes = this.readIntoByteArray(file);
        byte[] convertedBytes = this.convertIntoTempByteArray(originalBytes);
        if (this.lineConverter.atLeastOneMatchOccured()) {
            System.out.println("Converting [" + file + "]");
            this.writeConvertedBytesIntoFile(file, convertedBytes);
        } else {
            System.out.println("Not touching [" + file + "]");
        }
    }

    private void writeConvertedBytesIntoFile(File file, byte[] convertedBytes) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(convertedBytes);
        fos.flush();
        fos.close();
    }

    private byte[] convertIntoTempByteArray(byte[] input) throws IOException {
        String line;
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        InputStreamReader reader = new InputStreamReader(bais);
        BufferedReader breader = new BufferedReader(reader);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((line = breader.readLine()) != null) {
            String[] replacement = this.lineConverter.getReplacement(line);
            this.writeReplacement(baos, replacement);
        }
        return baos.toByteArray();
    }

    private void writeReplacement(OutputStream os, String[] replacement) throws IOException {
        for (int i = 0; i < replacement.length; ++i) {
            os.write(replacement[i].getBytes());
            os.write(this.lineTerminator.getBytes());
        }
    }
}

