/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.converter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.converter.ConversionException;
import org.slf4j.converter.ConverterFrame;
import org.slf4j.converter.FileSelector;
import org.slf4j.converter.InplaceFileConverter;
import org.slf4j.converter.RuleSetFactory;
import org.slf4j.converter.line.RuleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConverter {
    private RuleSet ruleSet;
    private List<ConversionException> exception;

    public static void main(String[] args) throws IOException {
        ConverterFrame frame = new ConverterFrame();
        frame.setVisible(true);
    }

    public ProjectConverter(int conversionType) {
        this.ruleSet = RuleSetFactory.getMatcherImpl(conversionType);
        if (this.ruleSet == null) {
            this.addException(new ConversionException("Conversion mode not implemented yet"));
        }
    }

    public void convertProject(File folder) {
        FileSelector fs = new FileSelector();
        List<File> fileList = fs.selectJavaFilesInFolder(folder);
        this.convertFileList(fileList);
    }

    private void convertFileList(List<File> lstFiles) {
        for (File currentFile : lstFiles) {
            this.convertFile(currentFile);
        }
    }

    private void convertFile(File file) {
        try {
            InplaceFileConverter fc = new InplaceFileConverter(this.ruleSet);
            fc.convert(file);
        }
        catch (IOException exc) {
            this.addException(new ConversionException(exc.toString()));
        }
    }

    public void addException(ConversionException exc) {
        if (this.exception == null) {
            this.exception = new ArrayList<ConversionException>();
        }
        this.exception.add(exc);
    }

    public void printException() {
        if (this.exception != null) {
            for (ConversionException exc : this.exception) {
                exc.print();
            }
            this.exception = null;
        }
    }
}

