/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.impl.MessageFormatter;

public final class JDK14LoggerAdapter
implements Logger {
    final java.util.logging.Logger logger;

    JDK14LoggerAdapter(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(String string) {
        this.logger.fine(string);
    }

    public void debug(Marker marker, String string) {
        this.debug(string);
    }

    public void debug(String string, Object object) {
        if (this.logger.isLoggable(Level.FINE)) {
            String string2 = MessageFormatter.format(string, object);
            this.logger.fine(string2);
        }
    }

    public void debug(Marker marker, String string, Object object) {
        this.debug(string, object);
    }

    public void debug(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.FINE)) {
            String string2 = MessageFormatter.format(string, object, object2);
            this.logger.fine(string2);
        }
    }

    public void debug(Marker marker, String string, Object object, Object object2) {
        this.debug(string, object, object2);
    }

    public void debug(String string, Throwable throwable) {
        this.logger.log(Level.FINE, string, throwable);
    }

    public void debug(Marker marker, String string, Throwable throwable) {
        this.debug(string, throwable);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public final boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(String string) {
        this.logger.info(string);
    }

    public void info(Marker marker, String string) {
        this.logger.info(string);
    }

    public void info(String string, Object object) {
        if (this.logger.isLoggable(Level.INFO)) {
            String string2 = MessageFormatter.format(string, object);
            this.logger.info(string2);
        }
    }

    public void info(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.INFO)) {
            String string2 = MessageFormatter.format(string, object, object2);
            this.logger.info(string2);
        }
    }

    public void info(String string, Throwable throwable) {
        this.logger.log(Level.INFO, string, throwable);
    }

    public void info(Marker marker, String string, Object object) {
        this.info(string, object);
    }

    public void info(Marker marker, String string, Object object, Object object2) {
        this.info(string, object, object2);
    }

    public void info(Marker marker, String string, Throwable throwable) {
        this.info(string, throwable);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(String string) {
        this.logger.warning(string);
    }

    public void warn(String string, Object object) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String string2 = MessageFormatter.format(string, object);
            this.logger.warning(string2);
        }
    }

    public void warn(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String string2 = MessageFormatter.format(string, object, object2);
            this.logger.warning(string2);
        }
    }

    public void warn(String string, Throwable throwable) {
        this.logger.log(Level.WARNING, string.toString(), throwable);
    }

    public void warn(Marker marker, String string) {
        this.warn(string);
    }

    public void warn(Marker marker, String string, Object object) {
        this.warn(string, object);
    }

    public void warn(Marker marker, String string, Object object, Object object2) {
        this.warn(string, object, object2);
    }

    public void warn(Marker marker, String string, Throwable throwable) {
        this.warn(string, throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(String string) {
        this.logger.severe(string);
    }

    public void error(String string, Object object) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String string2 = MessageFormatter.format(string, object);
            this.logger.severe(string2);
        }
    }

    public void error(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String string2 = MessageFormatter.format(string, object, object2);
            this.logger.severe(string2);
        }
    }

    public void error(String string, Throwable throwable) {
        this.logger.log(Level.SEVERE, string, throwable);
    }

    public void error(Marker marker, String string) {
        this.error(string);
    }

    public void error(Marker marker, String string, Object object) {
        this.error(string, object);
    }

    public void error(Marker marker, String string, Object object, Object object2) {
        this.error(string, object, object2);
    }

    public void error(Marker marker, String string, Throwable throwable) {
        this.error(string, throwable);
    }
}

