/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.impl.MessageFormatter;

public final class JDK14LoggerAdapter
implements Logger {
    final java.util.logging.Logger logger;

    JDK14LoggerAdapter(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(String msg) {
        this.logger.fine(msg);
    }

    public void debug(String format, Object arg) {
        if (this.logger.isLoggable(Level.FINE)) {
            String msgStr = MessageFormatter.format(format, arg);
            this.logger.fine(msgStr);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.FINE)) {
            String msgStr = MessageFormatter.format(format, arg1, arg2);
            this.logger.fine(msgStr);
        }
    }

    public void debug(String msg, Throwable t) {
        this.logger.log(Level.FINE, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String format, Object arg) {
        if (this.logger.isLoggable(Level.INFO)) {
            String msgStr = MessageFormatter.format(format, arg);
            this.logger.info(msgStr);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.INFO)) {
            String msgStr = MessageFormatter.format(format, arg1, arg2);
            this.logger.info(msgStr);
        }
    }

    public void info(String msg, Throwable t) {
        this.logger.log(Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warn(String msg) {
        this.logger.warning(msg);
    }

    public void warn(String format, Object arg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String msgStr = MessageFormatter.format(format, arg);
            this.logger.warning(msgStr);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String msgStr = MessageFormatter.format(format, arg1, arg2);
            this.logger.warning(msgStr);
        }
    }

    public void warn(String msg, Throwable t) {
        this.logger.log(Level.WARNING, msg.toString(), t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void error(String msg) {
        this.logger.severe(msg);
    }

    public void error(String format, Object arg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String msgStr = MessageFormatter.format(format, arg);
            this.logger.severe(msgStr);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String msgStr = MessageFormatter.format(format, arg1, arg2);
            this.logger.severe(msgStr);
        }
    }

    public void error(String msg, Throwable t) {
        this.logger.log(Level.SEVERE, msg, t);
    }
}

