/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.slf4j.impl.MarkerIgnoringBase;
import org.slf4j.impl.MessageFormatter;

public final class JDK14LoggerAdapter
extends MarkerIgnoringBase {
    final Logger logger;
    static String SELF = (class$org$slf4j$impl$JDK14LoggerAdapter == null ? (class$org$slf4j$impl$JDK14LoggerAdapter = JDK14LoggerAdapter.class$("org.slf4j.impl.JDK14LoggerAdapter")) : class$org$slf4j$impl$JDK14LoggerAdapter).getName();
    static String SUPER = (class$org$slf4j$impl$MarkerIgnoringBase == null ? (class$org$slf4j$impl$MarkerIgnoringBase = JDK14LoggerAdapter.class$("org.slf4j.impl.MarkerIgnoringBase")) : class$org$slf4j$impl$MarkerIgnoringBase).getName();
    static /* synthetic */ Class class$org$slf4j$impl$JDK14LoggerAdapter;
    static /* synthetic */ Class class$org$slf4j$impl$MarkerIgnoringBase;

    JDK14LoggerAdapter(Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(String msg) {
        this.log(Level.FINE, msg, null);
    }

    public void debug(String format, Object arg) {
        if (this.logger.isLoggable(Level.FINE)) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.FINE, msgStr, null);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.FINE)) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.FINE, msgStr, null);
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.logger.isLoggable(Level.FINE)) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.log(Level.FINE, msgStr, null);
        }
    }

    public void debug(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, null);
    }

    public void info(String format, Object arg) {
        if (this.logger.isLoggable(Level.INFO)) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.INFO, msgStr, null);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.INFO)) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.INFO, msgStr, null);
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.logger.isLoggable(Level.INFO)) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.log(Level.INFO, msgStr, null);
        }
    }

    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warn(String msg) {
        this.log(Level.WARNING, msg, null);
    }

    public void warn(String format, Object arg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.WARNING, msgStr, null);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.WARNING, msgStr, null);
        }
    }

    public void warn(String format, Object[] argArray) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.log(Level.WARNING, msgStr, null);
        }
    }

    public void warn(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void error(String msg) {
        this.log(Level.SEVERE, msg, null);
    }

    public void error(String format, Object arg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.SEVERE, msgStr, null);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.SEVERE, msgStr, null);
        }
    }

    public void error(String format, Object[] argArray) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.log(Level.SEVERE, msgStr, null);
        }
    }

    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    private void log(Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.getName());
        record.setThrown(t);
        this.fillCallerData(record);
        this.logger.log(record);
    }

    private final void fillCallerData(LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int selfIndex = -1;
        int i = 0;
        while (i < steArray.length) {
            String className = steArray[i].getClassName();
            if (className.equals(SELF) || className.equals(SUPER)) {
                selfIndex = i;
                break;
            }
            ++i;
        }
        int found = -1;
        int i2 = selfIndex + 1;
        while (i2 < steArray.length) {
            String className = steArray[i2].getClassName();
            if (!className.equals(SELF) && !className.equals(SUPER)) {
                found = i2;
                break;
            }
            ++i2;
        }
        if (found != -1) {
            StackTraceElement ste = steArray[found];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

