/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.migrator.internal.ProgressListener;

public class FileSelector {
    private final List<File> javaFileList = new ArrayList<File>();
    ProgressListener pl;

    FileSelector(ProgressListener pl) {
        this.pl = pl;
    }

    public List<File> selectJavaFilesInFolder(File folder) {
        if (folder.isDirectory()) {
            this.selectFiles(folder);
            return this.javaFileList;
        }
        throw new IllegalArgumentException("[" + folder + "] is not a directory");
    }

    private void selectFiles(File file) {
        if (file.isDirectory()) {
            this.pl.onDirectory(file);
            File[] files = file.listFiles();
            if (files != null) {
                for (File value : files) {
                    this.selectFiles(value);
                }
            }
        } else if (file.getName().endsWith(".java")) {
            this.pl.onFileAddition(file);
            this.javaFileList.add(file);
        }
    }
}

