/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactoryAdapter;
import org.slf4j.impl.NOPLoggerFA;

public class LoggerFactory {
    static LoggerFactoryAdapter adapter;

    private static LoggerFactoryAdapter getFactoryAdapterFromSystemProperties() {
        String string = null;
        try {
            string = System.getProperty("org.slf4j.factory");
            if (string == null) {
                return null;
            }
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{};
            Method method = clazz.getDeclaredMethod("getInstance", classArray);
            LoggerFactoryAdapter loggerFactoryAdapter = (LoggerFactoryAdapter)method.invoke(null, null);
            return loggerFactoryAdapter;
        }
        catch (Throwable throwable) {
            if (string == null) {
                LoggerFactory.reportFailure("Failed to fetch org.slf4j.factory system property.", throwable);
            } else {
                LoggerFactory.reportFailure("Failed to fetch LoggerFactoryAdapter using the " + string + " class.", throwable);
            }
            return null;
        }
    }

    static void reportFailure(String string, Throwable throwable) {
        System.err.println(string);
        System.err.println("Reported exception follows.");
        throwable.printStackTrace();
    }

    public static Logger getLogger(String string) {
        return adapter.getLogger(string);
    }

    public static Logger getLogger(String string, String string2) {
        return adapter.getLogger(string, string2);
    }

    public static Logger getLogger(Class clazz) {
        return adapter.getLogger(clazz.getName());
    }

    public static Logger getLogger(Class clazz, String string) {
        return adapter.getLogger(clazz.getName(), string);
    }

    static {
        String string = "org.slf4j.impl.NOPLoggerFA";
        System.out.println("SLF4J built for " + string);
        adapter = LoggerFactory.getFactoryAdapterFromSystemProperties();
        if (adapter != null) {
            System.out.println("However, SLF4J will use [" + adapter.getClass().getName() + "] adapter from system properties.");
        } else {
            try {
                adapter = new NOPLoggerFA();
            }
            catch (Exception exception) {
                LoggerFactory.reportFailure("Could not instantiate instance of class [" + string + "]", exception);
            }
        }
    }
}

