/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.slf4j.Logger;
import org.slf4j.impl.MessageFormatter;

public class SimpleLogger
implements Logger {
    String loggerName;
    private static long startTime = System.currentTimeMillis();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String INFO_STR = "INFO";
    private static String WARN_STR = "WARN";
    private static String ERROR_STR = "ERROR";

    SimpleLogger(String string) {
        this.loggerName = string;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void debug(String string) {
    }

    public void debug(String string, Object object) {
    }

    public void debug(String string, Object object, Object object2) {
    }

    public void debug(String string, Throwable throwable) {
    }

    private void log(String string, String string2, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = System.currentTimeMillis();
        stringBuffer.append(l - startTime);
        stringBuffer.append(" [");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append("] ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.loggerName);
        stringBuffer.append(" - ");
        stringBuffer.append(string2);
        stringBuffer.append(LINE_SEPARATOR);
        System.out.print(stringBuffer.toString());
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
        System.out.flush();
    }

    private void formatAndLog(String string, String string2, Object object, Object object2) {
        String string3 = MessageFormatter.format(string2, object, object2);
        this.log(string, string3, null);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String string) {
        this.log(INFO_STR, string, null);
    }

    public void info(String string, Object object) {
        this.formatAndLog(INFO_STR, string, object, null);
    }

    public void info(String string, Object object, Object object2) {
        this.formatAndLog(INFO_STR, string, object, object2);
    }

    public void info(String string, Throwable throwable) {
        this.log(INFO_STR, string.toString(), throwable);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String string) {
        this.log(WARN_STR, string.toString(), null);
    }

    public void warn(String string, Object object) {
        this.formatAndLog(WARN_STR, string, object, null);
    }

    public void warn(String string, Object object, Object object2) {
        this.formatAndLog(WARN_STR, string, object, object2);
    }

    public void warn(String string, Throwable throwable) {
        this.log(WARN_STR, string.toString(), throwable);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String string) {
        this.log(ERROR_STR, string.toString(), null);
    }

    public void error(String string, Object object) {
        this.formatAndLog(ERROR_STR, string, object, null);
    }

    public void error(String string, Object object, Object object2) {
        this.formatAndLog(ERROR_STR, string, object, object2);
    }

    public void error(String string, Throwable throwable) {
        this.log(ERROR_STR, string.toString(), throwable);
    }
}

