/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.impl.MessageFormatter;

public class SimpleLogger
implements Logger {
    private static long startTime = System.currentTimeMillis();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String INFO_STR = "INFO";
    private static String WARN_STR = "WARN";
    private static String ERROR_STR = "ERROR";
    String name;

    SimpleLogger(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isDebugEnabled(Marker marker) {
        return false;
    }

    public void debug(String string) {
    }

    public void debug(String string, Object object) {
    }

    public void debug(String string, Object object, Object object2) {
    }

    public void debug(String string, Throwable throwable) {
    }

    public void debug(Marker marker, String string) {
    }

    public void debug(Marker marker, String string, Object object) {
        this.debug(string, object);
    }

    public void debug(Marker marker, String string, Object object, Object object2) {
        this.debug(string, object, object2);
    }

    public void debug(Marker marker, String string, Throwable throwable) {
        this.debug(string, throwable);
    }

    private void log(String string, String string2, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = System.currentTimeMillis();
        stringBuffer.append(l - startTime);
        stringBuffer.append(" [");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append("] ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.name);
        stringBuffer.append(" - ");
        stringBuffer.append(string2);
        stringBuffer.append(LINE_SEPARATOR);
        System.out.print(stringBuffer.toString());
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
        System.out.flush();
    }

    private void formatAndLog(String string, String string2, Object object, Object object2) {
        String string3 = MessageFormatter.format(string2, object, object2);
        this.log(string, string3, null);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public void info(String string) {
        this.log(INFO_STR, string, null);
    }

    public void info(String string, Object object) {
        this.formatAndLog(INFO_STR, string, object, null);
    }

    public void info(String string, Object object, Object object2) {
        this.formatAndLog(INFO_STR, string, object, object2);
    }

    public void info(String string, Throwable throwable) {
        this.log(INFO_STR, string.toString(), throwable);
    }

    public void info(Marker marker, String string) {
        this.info(string);
    }

    public void info(Marker marker, String string, Object object) {
        this.info(string, object);
    }

    public void info(Marker marker, String string, Object object, Object object2) {
        this.info(string, object, object2);
    }

    public void info(Marker marker, String string, Throwable throwable) {
        this.info(string, throwable);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(String string) {
        this.log(WARN_STR, string.toString(), null);
    }

    public void warn(String string, Object object) {
        this.formatAndLog(WARN_STR, string, object, null);
    }

    public void warn(String string, Object object, Object object2) {
        this.formatAndLog(WARN_STR, string, object, object2);
    }

    public void warn(String string, Throwable throwable) {
        this.log(WARN_STR, string.toString(), throwable);
    }

    public void warn(Marker marker, String string) {
        this.warn(string);
    }

    public void warn(Marker marker, String string, Object object) {
        this.warn(string, object);
    }

    public void warn(Marker marker, String string, Object object, Object object2) {
        this.warn(string, object, object2);
    }

    public void warn(Marker marker, String string, Throwable throwable) {
        this.warn(string, throwable);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(String string) {
        this.log(ERROR_STR, string.toString(), null);
    }

    public void error(String string, Object object) {
        this.formatAndLog(ERROR_STR, string, object, null);
    }

    public void error(String string, Object object, Object object2) {
        this.formatAndLog(ERROR_STR, string, object, object2);
    }

    public void error(String string, Throwable throwable) {
        this.log(ERROR_STR, string.toString(), throwable);
    }

    public void error(Marker marker, String string) {
        this.error(string);
    }

    public void error(Marker marker, String string, Object object) {
        this.error(string, object);
    }

    public void error(Marker marker, String string, Object object, Object object2) {
        this.error(string, object, object2);
    }

    public void error(Marker marker, String string, Throwable throwable) {
        this.error(string, throwable);
    }
}

