/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface BinaryOperatorWithThrowable<T, E extends Throwable>
extends BinaryOperator<T> {
    public static <T, E extends Throwable> BinaryOperatorWithThrowable<T, E> castBinaryOperatorWithThrowable(BinaryOperatorWithThrowable<T, E> binaryoperatorwiththrowable) {
        return binaryoperatorwiththrowable;
    }

    public static <T, E extends Throwable> BinaryOperator<T> aBinaryOperatorThatUnsafelyThrowsUnchecked(BinaryOperatorWithThrowable<T, E> binaryoperatorwiththrowable) throws E {
        return binaryoperatorwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> BinaryOperatorWithThrowable<T, E> asBinaryOperatorWithThrowable(BinaryOperator<T> binaryoperator) {
        return binaryoperator::apply;
    }

    @Override
    default public T apply(T v1, T v2) {
        try {
            return this.applyWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public T applyWithThrowable(T var1, T var2) throws E;

    default public BinaryOperator<T> thatReturnsOnCatch(T defaultReturnValue) {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public BinaryOperator<T> thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public BinaryOperatorWithThrowable<T, E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public BinaryOperatorWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in BinaryOperatorWithThrowable with the arguments [{}, {}]");
    }

    default public BinaryOperatorWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public BinaryOperatorWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public BinaryOperatorWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

