/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface BooleanSupplierWithThrowable<E extends Throwable>
extends BooleanSupplier {
    public static <E extends Throwable> BooleanSupplierWithThrowable<E> castBooleanSupplierWithThrowable(BooleanSupplierWithThrowable<E> booleansupplierwiththrowable) {
        return booleansupplierwiththrowable;
    }

    public static <E extends Throwable> BooleanSupplier aBooleanSupplierThatUnsafelyThrowsUnchecked(BooleanSupplierWithThrowable<E> booleansupplierwiththrowable) throws E {
        return booleansupplierwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> BooleanSupplierWithThrowable<E> asBooleanSupplierWithThrowable(BooleanSupplier booleansupplier) {
        return booleansupplier::getAsBoolean;
    }

    @Override
    default public boolean getAsBoolean() {
        try {
            return this.getAsBooleanWithThrowable();
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public boolean getAsBooleanWithThrowable() throws E;

    default public BooleanSupplier thatReturnsOnCatch(boolean defaultReturnValue) {
        return () -> {
            try {
                return this.getAsBooleanWithThrowable();
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public BooleanSupplier thatUnsafelyThrowsUnchecked() throws E {
        return () -> {
            try {
                return this.getAsBooleanWithThrowable();
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return false;
            }
        };
    }

    default public BooleanSupplierWithThrowable<E> withLogging(Logger logger, String message) {
        return () -> {
            try {
                return this.getAsBooleanWithThrowable();
            }
            catch (Throwable throwable) {
                logger.error(message, throwable);
                throw throwable;
            }
        };
    }

    default public BooleanSupplierWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in BooleanSupplierWithThrowable");
    }

    default public BooleanSupplierWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public BooleanSupplierWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return () -> {
            try {
                return this.getAsBooleanWithThrowable();
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }
}

