/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface DoubleFunctionWithThrowable<R, E extends Throwable>
extends DoubleFunction<R> {
    public static <R, E extends Throwable> DoubleFunctionWithThrowable<R, E> castDoubleFunctionWithThrowable(DoubleFunctionWithThrowable<R, E> doublefunctionwiththrowable) {
        return doublefunctionwiththrowable;
    }

    public static <R, E extends Throwable> DoubleFunction<R> aDoubleFunctionThatUnsafelyThrowsUnchecked(DoubleFunctionWithThrowable<R, E> doublefunctionwiththrowable) throws E {
        return doublefunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <R, E extends Throwable> DoubleFunctionWithThrowable<R, E> asDoubleFunctionWithThrowable(DoubleFunction<R> doublefunction) {
        return doublefunction::apply;
    }

    @Override
    default public R apply(double v1) {
        try {
            return this.applyWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public R applyWithThrowable(double var1) throws E;

    default public DoubleFunction<Optional<R>> thatReturnsOptional() {
        return v1 -> {
            try {
                return Optional.ofNullable(this.applyWithThrowable(v1));
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        };
    }

    default public DoubleFunction<R> thatReturnsOnCatch(R defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public DoubleFunction<R> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public DoubleFunctionWithThrowable<R, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public DoubleFunctionWithThrowable<R, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in DoubleFunctionWithThrowable with the argument [{}]");
    }

    default public DoubleFunctionWithThrowable<R, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public DoubleFunctionWithThrowable<R, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public DoubleFunctionWithThrowable<R, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

