/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoublePredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface DoublePredicateWithThrowable<E extends Throwable>
extends DoublePredicate {
    public static <E extends Throwable> DoublePredicateWithThrowable<E> castDoublePredicateWithThrowable(DoublePredicateWithThrowable<E> doublepredicatewiththrowable) {
        return doublepredicatewiththrowable;
    }

    public static <E extends Throwable> DoublePredicate aDoublePredicateThatUnsafelyThrowsUnchecked(DoublePredicateWithThrowable<E> doublepredicatewiththrowable) throws E {
        return doublepredicatewiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> DoublePredicateWithThrowable<E> asDoublePredicateWithThrowable(DoublePredicate doublepredicate) {
        return doublepredicate::test;
    }

    @Override
    default public boolean test(double v1) {
        try {
            return this.testWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public boolean testWithThrowable(double var1) throws E;

    default public DoublePredicate thatReturnsOnCatch(boolean defaultReturnValue) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public DoublePredicate thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return false;
            }
        };
    }

    default public DoublePredicateWithThrowable<E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public DoublePredicateWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in DoublePredicateWithThrowable with the argument [{}]");
    }

    default public DoublePredicateWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public DoublePredicateWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public DoublePredicateWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

