/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface IntBinaryOperatorWithThrowable<E extends Throwable>
extends IntBinaryOperator {
    public static <E extends Throwable> IntBinaryOperatorWithThrowable<E> castIntBinaryOperatorWithThrowable(IntBinaryOperatorWithThrowable<E> intbinaryoperatorwiththrowable) {
        return intbinaryoperatorwiththrowable;
    }

    public static <E extends Throwable> IntBinaryOperator aIntBinaryOperatorThatUnsafelyThrowsUnchecked(IntBinaryOperatorWithThrowable<E> intbinaryoperatorwiththrowable) throws E {
        return intbinaryoperatorwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> IntBinaryOperatorWithThrowable<E> asIntBinaryOperatorWithThrowable(IntBinaryOperator intbinaryoperator) {
        return intbinaryoperator::applyAsInt;
    }

    @Override
    default public int applyAsInt(int v1, int v2) {
        try {
            return this.applyAsIntWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public int applyAsIntWithThrowable(int var1, int var2) throws E;

    default public IntBinaryOperator thatReturnsOnCatch(int defaultReturnValue) {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public IntBinaryOperator thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0;
            }
        };
    }

    default public IntBinaryOperatorWithThrowable<E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public IntBinaryOperatorWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in IntBinaryOperatorWithThrowable with the arguments [{}, {}]");
    }

    default public IntBinaryOperatorWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public IntBinaryOperatorWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public IntBinaryOperatorWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

