/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface LongFunctionWithThrowable<R, E extends Throwable>
extends LongFunction<R> {
    public static <R, E extends Throwable> LongFunctionWithThrowable<R, E> castLongFunctionWithThrowable(LongFunctionWithThrowable<R, E> longfunctionwiththrowable) {
        return longfunctionwiththrowable;
    }

    public static <R, E extends Throwable> LongFunction<R> aLongFunctionThatUnsafelyThrowsUnchecked(LongFunctionWithThrowable<R, E> longfunctionwiththrowable) throws E {
        return longfunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <R, E extends Throwable> LongFunctionWithThrowable<R, E> asLongFunctionWithThrowable(LongFunction<R> longfunction) {
        return longfunction::apply;
    }

    @Override
    default public R apply(long v1) {
        try {
            return this.applyWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public R applyWithThrowable(long var1) throws E;

    default public LongFunction<Optional<R>> thatReturnsOptional() {
        return v1 -> {
            try {
                return Optional.ofNullable(this.applyWithThrowable(v1));
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        };
    }

    default public LongFunction<R> thatReturnsOnCatch(R defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public LongFunction<R> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public LongFunctionWithThrowable<R, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public LongFunctionWithThrowable<R, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in LongFunctionWithThrowable with the argument [{}]");
    }

    default public LongFunctionWithThrowable<R, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public LongFunctionWithThrowable<R, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public LongFunctionWithThrowable<R, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

