/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjDoubleConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ObjDoubleConsumerWithThrowable<T, E extends Throwable>
extends ObjDoubleConsumer<T> {
    public static <T, E extends Throwable> ObjDoubleConsumerWithThrowable<T, E> castObjDoubleConsumerWithThrowable(ObjDoubleConsumerWithThrowable<T, E> objdoubleconsumerwiththrowable) {
        return objdoubleconsumerwiththrowable;
    }

    public static <T, E extends Throwable> ObjDoubleConsumer<T> aObjDoubleConsumerThatUnsafelyThrowsUnchecked(ObjDoubleConsumerWithThrowable<T, E> objdoubleconsumerwiththrowable) throws E {
        return objdoubleconsumerwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> ObjDoubleConsumerWithThrowable<T, E> asObjDoubleConsumerWithThrowable(ObjDoubleConsumer<T> objdoubleconsumer) {
        return objdoubleconsumer::accept;
    }

    @Override
    default public void accept(T v1, double v2) {
        try {
            this.acceptWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void acceptWithThrowable(T var1, double var2) throws E;

    default public ObjDoubleConsumer<T> thatThrowsNothing() {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public ObjDoubleConsumer<T> thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public ObjDoubleConsumerWithThrowable<T, E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public ObjDoubleConsumerWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ObjDoubleConsumerWithThrowable with the arguments [{}, {}]");
    }

    default public ObjDoubleConsumerWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ObjDoubleConsumerWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ObjDoubleConsumerWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

