/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ObjLongConsumerWithThrowable<T, E extends Throwable>
extends ObjLongConsumer<T> {
    public static <T, E extends Throwable> ObjLongConsumerWithThrowable<T, E> castObjLongConsumerWithThrowable(ObjLongConsumerWithThrowable<T, E> objlongconsumerwiththrowable) {
        return objlongconsumerwiththrowable;
    }

    public static <T, E extends Throwable> ObjLongConsumer<T> aObjLongConsumerThatUnsafelyThrowsUnchecked(ObjLongConsumerWithThrowable<T, E> objlongconsumerwiththrowable) throws E {
        return objlongconsumerwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> ObjLongConsumerWithThrowable<T, E> asObjLongConsumerWithThrowable(ObjLongConsumer<T> objlongconsumer) {
        return objlongconsumer::accept;
    }

    @Override
    default public void accept(T v1, long v2) {
        try {
            this.acceptWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void acceptWithThrowable(T var1, long var2) throws E;

    default public ObjLongConsumer<T> thatThrowsNothing() {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public ObjLongConsumer<T> thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public ObjLongConsumerWithThrowable<T, E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public ObjLongConsumerWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ObjLongConsumerWithThrowable with the arguments [{}, {}]");
    }

    default public ObjLongConsumerWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ObjLongConsumerWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ObjLongConsumerWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

