/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface PredicateWithThrowable<T, E extends Throwable>
extends Predicate<T> {
    public static <T, E extends Throwable> PredicateWithThrowable<T, E> castPredicateWithThrowable(PredicateWithThrowable<T, E> predicatewiththrowable) {
        return predicatewiththrowable;
    }

    public static <T, E extends Throwable> Predicate<T> aPredicateThatUnsafelyThrowsUnchecked(PredicateWithThrowable<T, E> predicatewiththrowable) throws E {
        return predicatewiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> PredicateWithThrowable<T, E> asPredicateWithThrowable(Predicate<T> predicate) {
        return predicate::test;
    }

    @Override
    default public boolean test(T v1) {
        try {
            return this.testWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public boolean testWithThrowable(T var1) throws E;

    default public Predicate<T> thatReturnsOnCatch(boolean defaultReturnValue) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public Predicate<T> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return false;
            }
        };
    }

    default public PredicateWithThrowable<T, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public PredicateWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in PredicateWithThrowable with the argument [{}]");
    }

    default public PredicateWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public PredicateWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public PredicateWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

