/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.OptionalDouble;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ToDoubleFunctionWithThrowable<T, E extends Throwable>
extends ToDoubleFunction<T> {
    public static <T, E extends Throwable> ToDoubleFunctionWithThrowable<T, E> castToDoubleFunctionWithThrowable(ToDoubleFunctionWithThrowable<T, E> todoublefunctionwiththrowable) {
        return todoublefunctionwiththrowable;
    }

    public static <T, E extends Throwable> ToDoubleFunction<T> aToDoubleFunctionThatUnsafelyThrowsUnchecked(ToDoubleFunctionWithThrowable<T, E> todoublefunctionwiththrowable) throws E {
        return todoublefunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> ToDoubleFunctionWithThrowable<T, E> asToDoubleFunctionWithThrowable(ToDoubleFunction<T> todoublefunction) {
        return todoublefunction::applyAsDouble;
    }

    @Override
    default public double applyAsDouble(T v1) {
        try {
            return this.applyAsDoubleWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public double applyAsDoubleWithThrowable(T var1) throws E;

    default public Function<T, OptionalDouble> thatReturnsOptional() {
        return v1 -> {
            try {
                return OptionalDouble.of(this.applyAsDoubleWithThrowable(v1));
            }
            catch (Throwable throwable) {
                return OptionalDouble.empty();
            }
        };
    }

    default public ToDoubleFunction<T> thatReturnsOnCatch(double defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public ToDoubleFunction<T> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0.0;
            }
        };
    }

    default public ToDoubleFunctionWithThrowable<T, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public ToDoubleFunctionWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ToDoubleFunctionWithThrowable with the argument [{}]");
    }

    default public ToDoubleFunctionWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ToDoubleFunctionWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ToDoubleFunctionWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

