/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ToIntFunctionWithThrowable<T, E extends Throwable>
extends ToIntFunction<T> {
    public static <T, E extends Throwable> ToIntFunctionWithThrowable<T, E> castToIntFunctionWithThrowable(ToIntFunctionWithThrowable<T, E> tointfunctionwiththrowable) {
        return tointfunctionwiththrowable;
    }

    public static <T, E extends Throwable> ToIntFunction<T> aToIntFunctionThatUnsafelyThrowsUnchecked(ToIntFunctionWithThrowable<T, E> tointfunctionwiththrowable) throws E {
        return tointfunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> ToIntFunctionWithThrowable<T, E> asToIntFunctionWithThrowable(ToIntFunction<T> tointfunction) {
        return tointfunction::applyAsInt;
    }

    @Override
    default public int applyAsInt(T v1) {
        try {
            return this.applyAsIntWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public int applyAsIntWithThrowable(T var1) throws E;

    default public Function<T, OptionalInt> thatReturnsOptional() {
        return v1 -> {
            try {
                return OptionalInt.of(this.applyAsIntWithThrowable(v1));
            }
            catch (Throwable throwable) {
                return OptionalInt.empty();
            }
        };
    }

    default public ToIntFunction<T> thatReturnsOnCatch(int defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyAsIntWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public ToIntFunction<T> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyAsIntWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0;
            }
        };
    }

    default public ToIntFunctionWithThrowable<T, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyAsIntWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public ToIntFunctionWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ToIntFunctionWithThrowable with the argument [{}]");
    }

    default public ToIntFunctionWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ToIntFunctionWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyAsIntWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ToIntFunctionWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyAsIntWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

