/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.analysis.ArrayProto;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.ClassProvider;
import org.jf.dexlib2.analysis.DexClassProvider;
import org.jf.dexlib2.analysis.OdexedFieldInstructionMapper;
import org.jf.dexlib2.analysis.PrimitiveProto;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnknownClassProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.analysis.reflection.ReflectionClassDef;
import org.jf.dexlib2.dexbacked.OatFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.immutable.ImmutableDexFile;
import org.jf.util.ExceptionWithContext;

public class ClassPath {
    @Nonnull
    private final TypeProto unknownClass;
    @Nonnull
    private List<ClassProvider> classProviders;
    private final boolean checkPackagePrivateAccess;
    public final int oatVersion;
    public static final int NOT_ART = -1;
    private final CacheLoader<String, TypeProto> classLoader = new CacheLoader<String, TypeProto>(){

        public TypeProto load(String type) throws Exception {
            if (type.charAt(0) == '[') {
                return new ArrayProto(ClassPath.this, type);
            }
            return new ClassProto(ClassPath.this, type);
        }
    };
    @Nonnull
    private LoadingCache<String, TypeProto> loadedClasses = CacheBuilder.newBuilder().build(this.classLoader);
    private static final Pattern dalvikCacheOdexPattern = Pattern.compile("@([^@]+)@classes.dex$");
    private final Supplier<OdexedFieldInstructionMapper> fieldInstructionMapperSupplier = Suppliers.memoize((Supplier)new Supplier<OdexedFieldInstructionMapper>(){

        public OdexedFieldInstructionMapper get() {
            return new OdexedFieldInstructionMapper(ClassPath.this.isArt());
        }
    });

    public ClassPath(ClassProvider ... classProviders) throws IOException {
        this(Arrays.asList(classProviders), false, -1);
    }

    public ClassPath(@Nonnull Iterable<? extends ClassProvider> classProviders, boolean checkPackagePrivateAccess, int oatVersion) {
        this.unknownClass = new UnknownClassProto(this);
        this.loadedClasses.put((Object)this.unknownClass.getType(), (Object)this.unknownClass);
        this.checkPackagePrivateAccess = checkPackagePrivateAccess;
        this.oatVersion = oatVersion;
        this.loadPrimitiveType("Z");
        this.loadPrimitiveType("B");
        this.loadPrimitiveType("S");
        this.loadPrimitiveType("C");
        this.loadPrimitiveType("I");
        this.loadPrimitiveType("J");
        this.loadPrimitiveType("F");
        this.loadPrimitiveType("D");
        this.loadPrimitiveType("L");
        this.classProviders = Lists.newArrayList(classProviders);
        this.classProviders.add(ClassPath.getBasicClasses());
    }

    private void loadPrimitiveType(String type) {
        this.loadedClasses.put((Object)type, (Object)new PrimitiveProto(this, type));
    }

    private static ClassProvider getBasicClasses() {
        return new DexClassProvider(new ImmutableDexFile(Opcodes.forApi(19), (Collection<? extends ClassDef>)ImmutableSet.of((Object)new ReflectionClassDef(Class.class), (Object)new ReflectionClassDef(Cloneable.class), (Object)new ReflectionClassDef(Object.class), (Object)new ReflectionClassDef(Serializable.class), (Object)new ReflectionClassDef(String.class), (Object)new ReflectionClassDef(Throwable.class), (Object[])new ReflectionClassDef[0])));
    }

    public boolean isArt() {
        return this.oatVersion != -1;
    }

    @Nonnull
    public TypeProto getClass(@Nonnull CharSequence type) {
        return (TypeProto)this.loadedClasses.getUnchecked((Object)type.toString());
    }

    @Nonnull
    public ClassDef getClassDef(String type) {
        for (ClassProvider provider : this.classProviders) {
            ClassDef classDef = provider.getClassDef(type);
            if (classDef == null) continue;
            return classDef;
        }
        throw new UnresolvedClassException("Could not resolve class %s", type);
    }

    @Nonnull
    public TypeProto getUnknownClass() {
        return this.unknownClass;
    }

    public boolean shouldCheckPackagePrivateAccess() {
        return this.checkPackagePrivateAccess;
    }

    @Nonnull
    public static ClassPath fromClassPath(Iterable<String> classPathDirs, Iterable<String> classPath, DexFile dexFile, int api, boolean experimental) {
        return ClassPath.fromClassPath(classPathDirs, classPath, dexFile, api, api == 17, experimental);
    }

    @Nonnull
    public static ClassPath fromClassPath(Iterable<String> classPathDirs, Iterable<String> classPath, DexFile dexFile, int api, boolean checkPackagePrivateAccess, boolean experimental) {
        ArrayList providers = Lists.newArrayList();
        int oatVersion = -1;
        for (String classPathEntry : classPath) {
            List<? extends DexFile> classPathDexFiles = ClassPath.loadClassPathEntry(classPathDirs, classPathEntry, api, experimental);
            if (oatVersion == -1) {
                for (DexFile dexFile2 : classPathDexFiles) {
                    if (!(dexFile2 instanceof OatFile.OatDexFile)) continue;
                    oatVersion = ((OatFile.OatDexFile)dexFile2).getOatVersion();
                    break;
                }
            }
            for (DexFile dexFile3 : classPathDexFiles) {
                providers.add(new DexClassProvider(dexFile3));
            }
        }
        providers.add(new DexClassProvider(dexFile));
        return new ClassPath(providers, checkPackagePrivateAccess, oatVersion);
    }

    @Nonnull
    public static ClassPath fromClassPath(Iterable<String> classPathDirs, Iterable<String> classPath, DexFile dexFile, int api, boolean checkPackagePrivateAccess, boolean experimental, int oatVersion) {
        ArrayList providers = Lists.newArrayList();
        for (String classPathEntry : classPath) {
            List<? extends DexFile> classPathDexFiles = ClassPath.loadClassPathEntry(classPathDirs, classPathEntry, api, experimental);
            for (DexFile dexFile2 : classPathDexFiles) {
                providers.add(new DexClassProvider(dexFile2));
            }
        }
        providers.add(new DexClassProvider(dexFile));
        return new ClassPath(providers, checkPackagePrivateAccess, oatVersion);
    }

    @Nonnull
    private static List<? extends DexFile> loadClassPathEntry(@Nonnull Iterable<String> classPathDirs, @Nonnull String bootClassPathEntry, int api, boolean experimental) {
        int extIndex;
        File rawEntry = new File(bootClassPathEntry);
        String entryName = rawEntry.getName();
        if (entryName.endsWith("@classes.dex")) {
            Matcher m = dalvikCacheOdexPattern.matcher(entryName);
            if (!m.find()) {
                throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", bootClassPathEntry), new Object[0]);
            }
            entryName = m.group(1);
        }
        String baseEntryName = (extIndex = entryName.lastIndexOf(".")) == -1 ? entryName : entryName.substring(0, extIndex);
        for (String classPathDir : classPathDirs) {
            String[] extensions = entryName.endsWith(".oat") ? new String[]{".oat"} : new String[]{"", ".odex", ".jar", ".apk", ".zip"};
            for (String ext : extensions) {
                File file = new File(classPathDir, baseEntryName + ext);
                if (!file.exists() || !file.isFile()) continue;
                if (!file.canRead()) {
                    System.err.println(String.format("warning: cannot open %s for reading. Will continue looking.", file.getPath()));
                    continue;
                }
                try {
                    return ImmutableList.of((Object)DexFileFactory.loadDexFile(file, api, experimental));
                }
                catch (DexFileFactory.DexFileNotFound dexFileNotFound) {
                }
                catch (DexFileFactory.MultipleDexFilesException ex) {
                    return ex.oatFile.getDexFiles();
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext((Throwable)ex, (String)"Error while reading boot class path entry \"%s\"", (Object[])new Object[]{bootClassPathEntry});
                }
            }
        }
        throw new ExceptionWithContext("Cannot locate boot class path file %s", new Object[]{bootClassPathEntry});
    }

    @Nonnull
    public OdexedFieldInstructionMapper getFieldInstructionMapper() {
        return (OdexedFieldInstructionMapper)this.fieldInstructionMapperSupplier.get();
    }
}

