/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.writer.DexWriter;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.BuilderContext;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodParameter;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderProtoReference;
import org.jf.dexlib2.writer.builder.BuilderReference;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.util.ExceptionWithContext;

public class DexBuilder
extends DexWriter<BuilderStringReference, BuilderStringReference, BuilderTypeReference, BuilderTypeReference, BuilderProtoReference, BuilderFieldReference, BuilderMethodReference, BuilderClassDef, BuilderAnnotation, BuilderAnnotationSet, BuilderTypeList, BuilderField, BuilderMethod, BuilderEncodedValues.BuilderEncodedValue, BuilderAnnotationElement> {
    @Nonnull
    private final BuilderContext context;

    @Nonnull
    public static DexBuilder makeDexBuilder() {
        BuilderContext context = new BuilderContext();
        return new DexBuilder(Opcodes.forApi(20), context);
    }

    @Deprecated
    @Nonnull
    public static DexBuilder makeDexBuilder(int api) {
        BuilderContext context = new BuilderContext();
        return new DexBuilder(Opcodes.forApi(api), context);
    }

    @Nonnull
    public static DexBuilder makeDexBuilder(@Nonnull Opcodes opcodes) {
        BuilderContext context = new BuilderContext();
        return new DexBuilder(opcodes, context);
    }

    private DexBuilder(@Nonnull Opcodes opcodes, @Nonnull BuilderContext context) {
        super(opcodes, context.stringPool, context.typePool, context.protoPool, context.fieldPool, context.methodPool, context.classPool, context.typeListPool, context.annotationPool, context.annotationSetPool);
        this.context = context;
    }

    @Nonnull
    public BuilderField internField(@Nonnull String definingClass, @Nonnull String name, @Nonnull String type, int accessFlags, @Nullable EncodedValue initialValue, @Nonnull Set<? extends Annotation> annotations) {
        return new BuilderField(this.context.fieldPool.internField(definingClass, name, type), accessFlags, this.context.internNullableEncodedValue(initialValue), this.context.annotationSetPool.internAnnotationSet(annotations));
    }

    @Nonnull
    public BuilderMethod internMethod(@Nonnull String definingClass, @Nonnull String name, @Nullable List<? extends MethodParameter> parameters, @Nonnull String returnType, int accessFlags, @Nonnull Set<? extends Annotation> annotations, @Nullable MethodImplementation methodImplementation) {
        if (parameters == null) {
            parameters = ImmutableList.of();
        }
        return new BuilderMethod(this.context.methodPool.internMethod(definingClass, name, (List<? extends CharSequence>)parameters, returnType), this.internMethodParameters((List<? extends MethodParameter>)parameters), accessFlags, this.context.annotationSetPool.internAnnotationSet(annotations), methodImplementation);
    }

    @Nonnull
    public BuilderClassDef internClassDef(@Nonnull String type, int accessFlags, @Nullable String superclass, @Nullable List<String> interfaces, @Nullable String sourceFile, @Nonnull Set<? extends Annotation> annotations, @Nullable Iterable<? extends BuilderField> fields, @Nullable Iterable<? extends BuilderMethod> methods) {
        if (interfaces == null) {
            interfaces = ImmutableList.of();
        } else {
            HashSet interfaces_copy = Sets.newHashSet((Iterable)interfaces);
            Iterator interfaceIterator = interfaces.iterator();
            while (interfaceIterator.hasNext()) {
                String iface = (String)interfaceIterator.next();
                if (!interfaces_copy.contains(iface)) {
                    interfaceIterator.remove();
                    continue;
                }
                interfaces_copy.remove(iface);
            }
        }
        return this.context.classPool.internClass(new BuilderClassDef(this.context.typePool.internType(type), accessFlags, this.context.typePool.internNullableType(superclass), this.context.typeListPool.internTypeList((List<? extends CharSequence>)interfaces), this.context.stringPool.internNullableString(sourceFile), this.context.annotationSetPool.internAnnotationSet(annotations), fields, methods));
    }

    @Nonnull
    public BuilderStringReference internStringReference(@Nonnull String string) {
        return this.context.stringPool.internString(string);
    }

    @Nullable
    public BuilderStringReference internNullableStringReference(@Nullable String string) {
        if (string != null) {
            return this.internStringReference(string);
        }
        return null;
    }

    @Nonnull
    public BuilderTypeReference internTypeReference(@Nonnull String type) {
        return this.context.typePool.internType(type);
    }

    @Nullable
    public BuilderTypeReference internNullableTypeReference(@Nullable String type) {
        if (type != null) {
            return this.internTypeReference(type);
        }
        return null;
    }

    @Nonnull
    public BuilderFieldReference internFieldReference(@Nonnull FieldReference field) {
        return this.context.fieldPool.internField(field);
    }

    @Nonnull
    public BuilderMethodReference internMethodReference(@Nonnull MethodReference method) {
        return this.context.methodPool.internMethod(method);
    }

    @Nonnull
    public BuilderReference internReference(@Nonnull Reference reference) {
        if (reference instanceof StringReference) {
            return this.internStringReference(((StringReference)reference).getString());
        }
        if (reference instanceof TypeReference) {
            return this.internTypeReference(((TypeReference)reference).getType());
        }
        if (reference instanceof MethodReference) {
            return this.internMethodReference((MethodReference)reference);
        }
        if (reference instanceof FieldReference) {
            return this.internFieldReference((FieldReference)reference);
        }
        throw new IllegalArgumentException("Could not determine type of reference");
    }

    @Nonnull
    private List<BuilderMethodParameter> internMethodParameters(@Nullable List<? extends MethodParameter> methodParameters) {
        if (methodParameters == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterator)Iterators.transform(methodParameters.iterator(), (Function)new Function<MethodParameter, BuilderMethodParameter>(){

            @Nullable
            public BuilderMethodParameter apply(MethodParameter input) {
                return DexBuilder.this.internMethodParameter(input);
            }
        }));
    }

    @Nonnull
    private BuilderMethodParameter internMethodParameter(@Nonnull MethodParameter methodParameter) {
        return new BuilderMethodParameter(this.context.typePool.internType(methodParameter.getType()), this.context.stringPool.internNullableString(methodParameter.getName()), this.context.annotationSetPool.internAnnotationSet(methodParameter.getAnnotations()));
    }

    @Override
    protected void writeEncodedValue(@Nonnull DexWriter.InternalEncodedValueWriter writer, @Nonnull BuilderEncodedValues.BuilderEncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 29: {
                BuilderEncodedValues.BuilderAnnotationEncodedValue annotationEncodedValue = (BuilderEncodedValues.BuilderAnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.typeReference, annotationEncodedValue.elements);
                break;
            }
            case 28: {
                BuilderEncodedValues.BuilderArrayEncodedValue arrayEncodedValue = (BuilderEncodedValues.BuilderArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.elements);
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((BuilderEncodedValues.BuilderEnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((BuilderEncodedValues.BuilderFieldEncodedValue)encodedValue).fieldReference);
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((BuilderEncodedValues.BuilderMethodEncodedValue)encodedValue).methodReference);
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 23: {
                writer.writeString(((BuilderEncodedValues.BuilderStringEncodedValue)encodedValue).stringReference);
                break;
            }
            case 24: {
                writer.writeType(((BuilderEncodedValues.BuilderTypeEncodedValue)encodedValue).typeReference);
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", new Object[]{encodedValue.getValueType()});
            }
        }
    }
}

