/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.writer.DexWriter;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;
import org.jf.dexlib2.writer.pool.AnnotationPool;
import org.jf.dexlib2.writer.pool.AnnotationSetPool;
import org.jf.dexlib2.writer.pool.ClassPool;
import org.jf.dexlib2.writer.pool.FieldPool;
import org.jf.dexlib2.writer.pool.MethodPool;
import org.jf.dexlib2.writer.pool.PoolClassDef;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.ProtoPool;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypeListPool;
import org.jf.dexlib2.writer.pool.TypePool;
import org.jf.util.ExceptionWithContext;

public class DexPool
extends DexWriter<CharSequence, StringReference, CharSequence, TypeReference, ProtoPool.Key, FieldReference, MethodReference, PoolClassDef, Annotation, Set<? extends Annotation>, TypeListPool.Key<? extends Collection<? extends CharSequence>>, Field, PoolMethod, EncodedValue, AnnotationElement> {
    @Nonnull
    public static DexPool makeDexPool() {
        return DexPool.makeDexPool(Opcodes.forApi(20));
    }

    @Deprecated
    @Nonnull
    public static DexPool makeDexPool(int api) {
        return DexPool.makeDexPool(Opcodes.forApi(api));
    }

    @Nonnull
    public static DexPool makeDexPool(@Nonnull Opcodes opcodes) {
        StringPool stringPool = new StringPool();
        TypePool typePool = new TypePool(stringPool);
        FieldPool fieldPool = new FieldPool(stringPool, typePool);
        TypeListPool typeListPool = new TypeListPool(typePool);
        ProtoPool protoPool = new ProtoPool(stringPool, typePool, typeListPool);
        MethodPool methodPool = new MethodPool(stringPool, typePool, protoPool);
        AnnotationPool annotationPool = new AnnotationPool(stringPool, typePool, fieldPool, methodPool);
        AnnotationSetPool annotationSetPool = new AnnotationSetPool(annotationPool);
        ClassPool classPool = new ClassPool(stringPool, typePool, fieldPool, methodPool, annotationSetPool, typeListPool);
        return new DexPool(opcodes, stringPool, typePool, protoPool, fieldPool, methodPool, classPool, typeListPool, annotationPool, annotationSetPool);
    }

    private DexPool(Opcodes opcodes, StringPool stringPool, TypePool typePool, ProtoPool protoPool, FieldPool fieldPool, MethodPool methodPool, ClassPool classPool, TypeListPool typeListPool, AnnotationPool annotationPool, AnnotationSetPool annotationSetPool) {
        super(opcodes, stringPool, typePool, protoPool, fieldPool, methodPool, classPool, typeListPool, annotationPool, annotationSetPool);
    }

    public static void writeTo(@Nonnull DexDataStore dataStore, @Nonnull DexFile input) throws IOException {
        DexPool dexPool = DexPool.makeDexPool();
        for (ClassDef classDef : input.getClasses()) {
            ((ClassPool)dexPool.classSection).intern(classDef);
        }
        dexPool.writeTo(dataStore);
    }

    public static void writeTo(@Nonnull String path, @Nonnull DexFile input) throws IOException {
        DexPool dexPool = DexPool.makeDexPool();
        for (ClassDef classDef : input.getClasses()) {
            ((ClassPool)dexPool.classSection).intern(classDef);
        }
        dexPool.writeTo(new FileDataStore(new File(path)));
    }

    @Override
    protected void writeEncodedValue(@Nonnull DexWriter.InternalEncodedValueWriter writer, @Nonnull EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.getType(), annotationEncodedValue.getElements());
                break;
            }
            case 28: {
                ArrayEncodedValue arrayEncodedValue = (ArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.getValue());
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)encodedValue).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)encodedValue).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)encodedValue).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)encodedValue).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)encodedValue).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)encodedValue).getValue());
                break;
            }
            case 23: {
                writer.writeString(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                writer.writeType(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", new Object[]{encodedValue.getValueType()});
            }
        }
    }

    public static void internEncodedValue(@Nonnull EncodedValue encodedValue, @Nonnull StringPool stringPool, @Nonnull TypePool typePool, @Nonnull FieldPool fieldPool, @Nonnull MethodPool methodPool) {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                typePool.intern(annotationEncodedValue.getType());
                for (AnnotationElement annotationElement : annotationEncodedValue.getElements()) {
                    stringPool.intern(annotationElement.getName());
                    DexPool.internEncodedValue(annotationElement.getValue(), stringPool, typePool, fieldPool, methodPool);
                }
                break;
            }
            case 28: {
                for (EncodedValue encodedValue2 : ((ArrayEncodedValue)encodedValue).getValue()) {
                    DexPool.internEncodedValue(encodedValue2, stringPool, typePool, fieldPool, methodPool);
                }
                break;
            }
            case 23: {
                stringPool.intern(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                typePool.intern(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                fieldPool.intern(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                fieldPool.intern(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                methodPool.intern(((MethodEncodedValue)encodedValue).getValue());
            }
        }
    }
}

