/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.schedule.quartz.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.smallmind.schedule.quartz.spring.CronJob;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class CronJobMapFactoryBean
implements FactoryBean<Map<JobDetail, List<CronTrigger>>>,
BeanPostProcessor {
    private final HashMap<JobDetail, List<CronTrigger>> jobMap = new HashMap();
    private List<String> allowedJobIds;

    public void setAllowedJobIds(List<String> allowedJobIds) {
        this.allowedJobIds = allowedJobIds;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return Map.class;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof CronJob) {
            JobKey jobKey = ((CronJob)bean).getJobDetail().getKey();
            String jobId = jobKey.getGroup() + "." + jobKey.getName();
            for (String allowedJobId : this.allowedJobIds) {
                if (!allowedJobId.equals(jobId)) continue;
                this.jobMap.put(((CronJob)bean).getJobDetail(), List.of(((CronJob)bean).getCronTrigger()));
                break;
            }
        }
        return bean;
    }

    public Map<JobDetail, List<CronTrigger>> getObject() {
        return this.jobMap;
    }
}

