/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.schedule.quartz.spring;

import java.io.IOException;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.util.OnOrOff;
import org.smallmind.schedule.quartz.spring.SpringJobFactory;
import org.smallmind.scribe.pen.LoggerManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class SpringSchedulerFactory
extends StdSchedulerFactory
implements ApplicationContextAware,
ApplicationListener<ContextClosedEvent> {
    private SpringJobFactory jobFactory;
    private OnOrOff activeMode = OnOrOff.ON;

    public SpringSchedulerFactory(Properties properties) throws SchedulerException {
        super(properties);
    }

    public void setActiveMode(OnOrOff activeMode) {
        this.activeMode = activeMode;
    }

    public synchronized void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.jobFactory = new SpringJobFactory(applicationContext);
    }

    public synchronized void onApplicationEvent(ContextClosedEvent event) {
        try {
            Scheduler scheduler = super.getScheduler();
            if (scheduler != null) {
                scheduler.shutdown(true);
            }
        }
        catch (SchedulerException schedulerException) {
            LoggerManager.getLogger(SpringSchedulerFactory.class).error((Throwable)schedulerException);
        }
        if (this.jobFactory != null) {
            try {
                this.jobFactory.close();
            }
            catch (IOException ioException) {
                LoggerManager.getLogger(SpringSchedulerFactory.class).error((Throwable)ioException);
            }
        }
    }

    public synchronized Scheduler getScheduler() throws SchedulerException {
        Scheduler scheduler = super.getScheduler();
        scheduler.setJobFactory((JobFactory)this.jobFactory);
        switch (this.activeMode) {
            case ON: {
                scheduler.start();
                break;
            }
            case OFF: {
                scheduler.standby();
                break;
            }
            default: {
                throw new UnknownSwitchCaseException(this.activeMode.name(), new Object[0]);
            }
        }
        return scheduler;
    }
}

