/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.channels.AsynchronousSocketChannelProxy;
import org.smartboot.socket.enhance.FutureCompletionHandler;
import org.smartboot.socket.extension.ssl.HandshakeModel;
import org.smartboot.socket.extension.ssl.SslService;

public class SslAsynchronousSocketChannel
extends AsynchronousSocketChannelProxy {
    private final VirtualBuffer netWriteBuffer;
    private final VirtualBuffer netReadBuffer;
    private final VirtualBuffer appReadBuffer;
    private SSLEngine sslEngine = null;
    private HandshakeModel handshakeModel;
    private final SslService sslService;
    private boolean handshake = true;
    private int adaptiveWriteSize = -1;

    public SslAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel, SslService sslService, BufferPage bufferPage) {
        super(asynchronousSocketChannel);
        this.handshakeModel = sslService.createSSLEngine(asynchronousSocketChannel, bufferPage);
        this.sslService = sslService;
        this.sslEngine = this.handshakeModel.getSslEngine();
        this.netWriteBuffer = this.handshakeModel.getNetWriteBuffer();
        this.netReadBuffer = this.handshakeModel.getNetReadBuffer();
        this.appReadBuffer = this.handshakeModel.getAppReadBuffer();
    }

    @Override
    public <A> void read(final ByteBuffer dst, final long timeout, final TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (this.handshake) {
            this.doHandshake(dst, timeout, unit, attachment, handler);
            return;
        }
        ByteBuffer appBuffer = this.appReadBuffer.buffer();
        if (appBuffer.hasRemaining()) {
            this.handleAppBuffer(dst, attachment, handler, appBuffer);
            return;
        }
        ByteBuffer netBuffer = this.netReadBuffer.buffer();
        if (netBuffer.hasRemaining()) {
            appBuffer.compact();
            this.doUnWrap(netBuffer, appBuffer);
            appBuffer.flip();
        }
        if (appBuffer.hasRemaining()) {
            this.handleAppBuffer(dst, attachment, handler, appBuffer);
            return;
        }
        netBuffer.compact();
        this.asynchronousSocketChannel.read(netBuffer, timeout, unit, attachment, new CompletionHandler<Integer, A>(){
            int index = 0;

            @Override
            public void completed(Integer result, A attachment) {
                if (result < 0) {
                    handler.completed(result, attachment);
                    return;
                }
                ByteBuffer appBuffer = SslAsynchronousSocketChannel.this.appReadBuffer.buffer();
                if (appBuffer.hasRemaining()) {
                    this.failed(new IOException("\u89e3\u5305\u7b97\u6cd5\u5f02\u5e38..."), attachment);
                    return;
                }
                appBuffer.clear();
                ByteBuffer netBuffer = SslAsynchronousSocketChannel.this.netReadBuffer.buffer();
                netBuffer.flip();
                SSLEngineResult.Status status = SslAsynchronousSocketChannel.this.doUnWrap(netBuffer, appBuffer);
                appBuffer.flip();
                if (appBuffer.hasRemaining()) {
                    if (status != SSLEngineResult.Status.OK) {
                        throw new IllegalStateException();
                    }
                    this.index = 0;
                    SslAsynchronousSocketChannel.this.handleAppBuffer(dst, attachment, handler, appBuffer);
                    return;
                }
                if (this.index >= 16) {
                    System.err.println("maybe trigger bug here...");
                }
                if (status == SSLEngineResult.Status.OK && this.index < 16) {
                    System.err.println("Possible exception on appBuffer.");
                    ++this.index;
                    this.completed(result, attachment);
                } else {
                    netBuffer.compact();
                    SslAsynchronousSocketChannel.this.asynchronousSocketChannel.read(netBuffer, timeout, unit, attachment, this);
                }
            }

            @Override
            public void failed(Throwable exc, A attachment) {
                handler.failed(exc, attachment);
            }
        });
    }

    private <A> void handleAppBuffer(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler, ByteBuffer appBuffer) {
        int pos = dst.position();
        if (appBuffer.remaining() > dst.remaining()) {
            int limit = appBuffer.limit();
            appBuffer.limit(appBuffer.position() + dst.remaining());
            dst.put(appBuffer);
            appBuffer.limit(limit);
        } else {
            dst.put(appBuffer);
        }
        handler.completed(dst.position() - pos, attachment);
    }

    private <A> void doHandshake(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.handshakeModel.setHandshakeCallback(() -> {
            this.handshake = false;
            SslAsynchronousSocketChannel sslAsynchronousSocketChannel = this;
            synchronized (sslAsynchronousSocketChannel) {
                this.handshakeModel.getAppWriteBuffer().clean();
                this.netReadBuffer.buffer().flip();
                this.netWriteBuffer.buffer().clear();
                this.appReadBuffer.buffer().clear().flip();
                this.notifyAll();
            }
            if (this.handshakeModel.getException() != null) {
                handler.failed(this.handshakeModel.getException(), (Object)attachment);
            } else {
                this.read(dst, timeout, unit, attachment, handler);
            }
            this.handshakeModel = null;
        });
        this.sslService.doHandshake(this.handshakeModel);
    }

    private SSLEngineResult.Status doUnWrap(ByteBuffer netBuffer, ByteBuffer appBuffer) {
        try {
            SSLEngineResult result = this.sslEngine.unwrap(netBuffer, appBuffer);
            boolean closed = false;
            while (!closed && result.getStatus() != SSLEngineResult.Status.OK) {
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        if (!this.sslService.isDebug()) break;
                        System.out.println("BUFFER_OVERFLOW error,net:" + netBuffer + " app:" + appBuffer);
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        if (netBuffer.limit() == netBuffer.capacity() && !netBuffer.hasRemaining()) {
                            if (this.sslService.isDebug()) {
                                System.err.println("BUFFER_UNDERFLOW error");
                            }
                        } else if (this.sslService.isDebug()) {
                            System.out.println("BUFFER_UNDERFLOW,continue read:" + netBuffer);
                        }
                        return result.getStatus();
                    }
                    case CLOSED: {
                        if (this.sslService.isDebug()) {
                            System.out.println("doUnWrap Result:" + (Object)((Object)result.getStatus()));
                        }
                        closed = true;
                        break;
                    }
                    default: {
                        if (!this.sslService.isDebug()) break;
                        System.out.println("doUnWrap Result:" + (Object)((Object)result.getStatus()));
                    }
                }
                result = this.sslEngine.unwrap(netBuffer, appBuffer);
            }
            return result.getStatus();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        FutureCompletionHandler readFuture = new FutureCompletionHandler();
        this.read(dst, 0L, TimeUnit.MILLISECONDS, null, (CompletionHandler)readFuture);
        return readFuture;
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void write(final ByteBuffer src, final long timeout, final TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (this.handshake) {
            this.checkInitialized();
        }
        final int pos = src.position();
        try {
            this.doWrap(src);
        }
        catch (SSLException e) {
            handler.failed(e, attachment);
            return;
        }
        if (src.position() - pos == 0) {
            System.err.println("write error:" + src + " netWrite:" + this.netWriteBuffer.buffer());
        }
        this.asynchronousSocketChannel.write(this.netWriteBuffer.buffer(), timeout, unit, attachment, new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer result, A attachment) {
                if (result == -1) {
                    System.err.println("aaaaaaaaaaa");
                }
                if (SslAsynchronousSocketChannel.this.netWriteBuffer.buffer().hasRemaining()) {
                    SslAsynchronousSocketChannel.this.asynchronousSocketChannel.write(SslAsynchronousSocketChannel.this.netWriteBuffer.buffer(), timeout, unit, attachment, this);
                } else {
                    handler.completed(src.position() - pos, attachment);
                }
            }

            @Override
            public void failed(Throwable exc, A attachment) {
                handler.failed(exc, attachment);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialized() {
        if (!this.handshake) {
            return;
        }
        SslAsynchronousSocketChannel sslAsynchronousSocketChannel = this;
        synchronized (sslAsynchronousSocketChannel) {
            if (!this.handshake) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void doWrap(ByteBuffer writeBuffer) throws SSLException {
        ByteBuffer netBuffer = this.netWriteBuffer.buffer();
        netBuffer.compact();
        int limit = writeBuffer.limit();
        if (this.adaptiveWriteSize > 0 && writeBuffer.remaining() > this.adaptiveWriteSize) {
            writeBuffer.limit(writeBuffer.position() + this.adaptiveWriteSize);
        }
        SSLEngineResult result = this.sslEngine.wrap(writeBuffer, netBuffer);
        while (result.getStatus() != SSLEngineResult.Status.OK) {
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    netBuffer.clear();
                    writeBuffer.limit(writeBuffer.position() + (writeBuffer.limit() - writeBuffer.position() >> 1));
                    this.adaptiveWriteSize = writeBuffer.remaining();
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    if (!this.sslService.isDebug()) break;
                    System.err.println("doWrap BUFFER_UNDERFLOW");
                    break;
                }
                case CLOSED: {
                    throw new SSLException("SSLEngine has " + (Object)((Object)result.getStatus()));
                }
                default: {
                    if (!this.sslService.isDebug()) break;
                    System.out.println("doWrap Result:" + (Object)((Object)result.getStatus()));
                }
            }
            result = this.sslEngine.wrap(writeBuffer, netBuffer);
        }
        writeBuffer.limit(limit);
        netBuffer.flip();
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.netWriteBuffer.clean();
        this.netReadBuffer.clean();
        this.appReadBuffer.clean();
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        this.sslEngine.closeOutbound();
        this.asynchronousSocketChannel.close();
    }
}

