/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.extension.ssl.HandshakeModel;

public final class SslService {
    private boolean debug;
    private final SSLContext sslContext;
    private final Consumer<SSLEngine> consumer;
    private final CompletionHandler<Integer, HandshakeModel> handshakeCompletionHandler = new CompletionHandler<Integer, HandshakeModel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, HandshakeModel attachment) {
            if (result == -1) {
                this.failed((Throwable)new IOException("eof"), attachment);
                return;
            }
            HandshakeModel handshakeModel = attachment;
            synchronized (handshakeModel) {
                SslService.this.doHandshake(attachment);
            }
        }

        @Override
        public void failed(Throwable exc, HandshakeModel attachment) {
            attachment.setException(exc);
            attachment.getHandshakeCallback().callback();
        }
    };

    public SslService(SSLContext sslContext, Consumer<SSLEngine> consumer) {
        this.sslContext = sslContext;
        this.consumer = consumer;
    }

    HandshakeModel createSSLEngine(AsynchronousSocketChannel socketChannel, BufferPage bufferPage) {
        try {
            HandshakeModel handshakeModel = new HandshakeModel();
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            SSLSession session = sslEngine.getSession();
            this.consumer.accept(sslEngine);
            handshakeModel.setSslEngine(sslEngine);
            handshakeModel.setAppWriteBuffer(bufferPage.allocate(session.getApplicationBufferSize()));
            handshakeModel.setNetWriteBuffer(bufferPage.allocate(session.getPacketBufferSize()));
            handshakeModel.getNetWriteBuffer().buffer().flip();
            handshakeModel.setAppReadBuffer(bufferPage.allocate(session.getApplicationBufferSize()));
            handshakeModel.setNetReadBuffer(bufferPage.allocate(session.getPacketBufferSize()));
            sslEngine.beginHandshake();
            handshakeModel.setSocketChannel(socketChannel);
            return handshakeModel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doHandshake(HandshakeModel handshakeModel) {
        SSLEngineResult result = null;
        try {
            SSLEngineResult.HandshakeStatus handshakeStatus = null;
            ByteBuffer netReadBuffer = handshakeModel.getNetReadBuffer().buffer();
            ByteBuffer appReadBuffer = handshakeModel.getAppReadBuffer().buffer();
            ByteBuffer netWriteBuffer = handshakeModel.getNetWriteBuffer().buffer();
            ByteBuffer appWriteBuffer = handshakeModel.getAppWriteBuffer().buffer();
            SSLEngine engine = handshakeModel.getSslEngine();
            if (handshakeModel.getException() != null) {
                if (this.debug) {
                    System.out.println("the ssl handshake is terminated");
                }
                handshakeModel.getHandshakeCallback().callback();
                return;
            }
            block22: while (!handshakeModel.isFinished()) {
                handshakeStatus = engine.getHandshakeStatus();
                if (this.debug) {
                    System.out.println("\u63e1\u624b\u72b6\u6001:" + (Object)((Object)handshakeStatus));
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        netReadBuffer.flip();
                        if (!netReadBuffer.hasRemaining()) {
                            netReadBuffer.clear();
                            handshakeModel.getSocketChannel().read(netReadBuffer, handshakeModel, this.handshakeCompletionHandler);
                            return;
                        }
                        result = engine.unwrap(netReadBuffer, appReadBuffer);
                        netReadBuffer.compact();
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                            handshakeModel.setFinished(true);
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                continue block22;
                            }
                            case BUFFER_OVERFLOW: {
                                System.err.println("doHandshake BUFFER_OVERFLOW");
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                if (netReadBuffer.position() > 0) {
                                    handshakeModel.getSocketChannel().read(netReadBuffer, handshakeModel, this.handshakeCompletionHandler);
                                } else {
                                    System.out.println("doHandshake BUFFER_UNDERFLOW");
                                }
                                return;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                    case NEED_WRAP: {
                        if (netWriteBuffer.hasRemaining()) {
                            if (this.debug) {
                                System.out.println("\u6570\u636e\u672a\u8f93\u51fa\u5b8c\u6bd5...");
                            }
                            handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletionHandler);
                            return;
                        }
                        netWriteBuffer.clear();
                        result = engine.wrap(appWriteBuffer, netWriteBuffer);
                        switch (result.getStatus()) {
                            case OK: {
                                appWriteBuffer.clear();
                                netWriteBuffer.flip();
                                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                    handshakeModel.setFinished(true);
                                }
                                handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletionHandler);
                                return;
                            }
                            case BUFFER_OVERFLOW: {
                                if (!this.debug) continue block22;
                                System.out.println("NEED_WRAP BUFFER_OVERFLOW");
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLException("Buffer underflow occurred after a wrap. I don't think we should ever get here.");
                            }
                            case CLOSED: {
                                if (this.debug) {
                                    System.out.println("closed");
                                }
                                try {
                                    netWriteBuffer.flip();
                                    netReadBuffer.clear();
                                }
                                catch (Exception e) {
                                    if (!this.debug) continue block22;
                                    System.out.println("Failed to send server's CLOSE message due to socket channel's failure.");
                                }
                                continue block22;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        continue block22;
                    }
                    case FINISHED: {
                        if (!this.debug) continue block22;
                        System.out.println("HandshakeFinished");
                        continue block22;
                    }
                    case NOT_HANDSHAKING: {
                        if (!this.debug) continue block22;
                        System.out.println("NOT_HANDSHAKING");
                        continue block22;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)handshakeStatus));
            }
            if (this.debug) {
                System.out.println("\u63e1\u624b\u5b8c\u6bd5");
            }
            handshakeModel.getHandshakeCallback().callback();
        }
        catch (Exception e) {
            if (this.debug) {
                System.out.println("ignore doHandshake exception:" + e.getMessage());
            }
            this.handshakeCompletionHandler.failed(e, handshakeModel);
        }
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    boolean isDebug() {
        return this.debug;
    }
}

