/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.UdpChannel;
import org.smartboot.socket.transport.WriteBuffer;

final class UdpAioSession
extends AioSession {
    private final UdpChannel udpChannel;
    private final SocketAddress remote;
    private final WriteBuffer byteBuf;

    UdpAioSession(UdpChannel udpChannel, SocketAddress remote, BufferPage bufferPage) {
        this.udpChannel = udpChannel;
        this.remote = remote;
        Consumer<WriteBuffer> consumer = var -> {
            VirtualBuffer writeBuffer = var.poll();
            if (writeBuffer != null) {
                udpChannel.write(writeBuffer, this);
            }
        };
        this.byteBuf = new WriteBuffer(bufferPage, consumer, udpChannel.config.getWriteBufferSize(), 1);
        udpChannel.config.getProcessor().stateEvent((AioSession)this, StateMachineEnum.NEW_SESSION, null);
    }

    public WriteBuffer writeBuffer() {
        return this.byteBuf;
    }

    public ByteBuffer readBuffer() {
        throw new UnsupportedOperationException();
    }

    public void awaitRead() {
        throw new UnsupportedOperationException();
    }

    public void signalRead() {
        throw new UnsupportedOperationException();
    }

    public void close(boolean immediate) {
        this.byteBuf.flush();
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return (InetSocketAddress)this.udpChannel.getChannel().getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.remote;
    }
}

